// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of workload this item represents. </summary>
    public readonly partial struct BackupDataSourceType : IEquatable<BackupDataSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupDataSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupDataSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string VmValue = "VM";
        private const string FileFolderValue = "FileFolder";
        private const string AzureSqlDBValue = "AzureSqlDb";
        private const string SqlDBValue = "SQLDB";
        private const string ExchangeValue = "Exchange";
        private const string SharepointValue = "Sharepoint";
        private const string VMwareVmValue = "VMwareVM";
        private const string SystemStateValue = "SystemState";
        private const string ClientValue = "Client";
        private const string GenericDataSourceValue = "GenericDataSource";
        private const string SqlDatabaseValue = "SQLDataBase";
        private const string AzureFileShareValue = "AzureFileShare";
        private const string SapHanaDatabaseValue = "SAPHanaDatabase";
        private const string SapAseDatabaseValue = "SAPAseDatabase";
        private const string SapHanaDBInstanceValue = "SAPHanaDBInstance";

        /// <summary> Invalid. </summary>
        public static BackupDataSourceType Invalid { get; } = new BackupDataSourceType(InvalidValue);
        /// <summary> VM. </summary>
        public static BackupDataSourceType Vm { get; } = new BackupDataSourceType(VmValue);
        /// <summary> FileFolder. </summary>
        public static BackupDataSourceType FileFolder { get; } = new BackupDataSourceType(FileFolderValue);
        /// <summary> AzureSqlDb. </summary>
        public static BackupDataSourceType AzureSqlDB { get; } = new BackupDataSourceType(AzureSqlDBValue);
        /// <summary> SQLDB. </summary>
        public static BackupDataSourceType SqlDB { get; } = new BackupDataSourceType(SqlDBValue);
        /// <summary> Exchange. </summary>
        public static BackupDataSourceType Exchange { get; } = new BackupDataSourceType(ExchangeValue);
        /// <summary> Sharepoint. </summary>
        public static BackupDataSourceType Sharepoint { get; } = new BackupDataSourceType(SharepointValue);
        /// <summary> VMwareVM. </summary>
        public static BackupDataSourceType VMwareVm { get; } = new BackupDataSourceType(VMwareVmValue);
        /// <summary> SystemState. </summary>
        public static BackupDataSourceType SystemState { get; } = new BackupDataSourceType(SystemStateValue);
        /// <summary> Client. </summary>
        public static BackupDataSourceType Client { get; } = new BackupDataSourceType(ClientValue);
        /// <summary> GenericDataSource. </summary>
        public static BackupDataSourceType GenericDataSource { get; } = new BackupDataSourceType(GenericDataSourceValue);
        /// <summary> SQLDataBase. </summary>
        public static BackupDataSourceType SqlDatabase { get; } = new BackupDataSourceType(SqlDatabaseValue);
        /// <summary> AzureFileShare. </summary>
        public static BackupDataSourceType AzureFileShare { get; } = new BackupDataSourceType(AzureFileShareValue);
        /// <summary> SAPHanaDatabase. </summary>
        public static BackupDataSourceType SapHanaDatabase { get; } = new BackupDataSourceType(SapHanaDatabaseValue);
        /// <summary> SAPAseDatabase. </summary>
        public static BackupDataSourceType SapAseDatabase { get; } = new BackupDataSourceType(SapAseDatabaseValue);
        /// <summary> SAPHanaDBInstance. </summary>
        public static BackupDataSourceType SapHanaDBInstance { get; } = new BackupDataSourceType(SapHanaDBInstanceValue);
        /// <summary> Determines if two <see cref="BackupDataSourceType"/> values are the same. </summary>
        public static bool operator ==(BackupDataSourceType left, BackupDataSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupDataSourceType"/> values are not the same. </summary>
        public static bool operator !=(BackupDataSourceType left, BackupDataSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupDataSourceType"/>. </summary>
        public static implicit operator BackupDataSourceType(string value) => new BackupDataSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupDataSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupDataSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
