// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Common settings field for backup management. </summary>
    public partial class BackupCommonSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupCommonSettings"/>. </summary>
        public BackupCommonSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupCommonSettings"/>. </summary>
        /// <param name="timeZone"> TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time". </param>
        /// <param name="isSqlCompression"> SQL compression flag. </param>
        /// <param name="isCompression">
        /// Workload compression flag. This has been added so that 'isSqlCompression'
        /// will be deprecated once clients upgrade to consider this flag.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupCommonSettings(string timeZone, bool? isSqlCompression, bool? isCompression, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TimeZone = timeZone;
            IsSqlCompression = isSqlCompression;
            IsCompression = isCompression;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time". </summary>
        public string TimeZone { get; set; }
        /// <summary> SQL compression flag. </summary>
        public bool? IsSqlCompression { get; set; }
        /// <summary>
        /// Workload compression flag. This has been added so that 'isSqlCompression'
        /// will be deprecated once clients upgrade to consider this flag.
        /// </summary>
        public bool? IsCompression { get; set; }
    }
}
