// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Whether storage account lock is to be acquired for this container or not. </summary>
    public readonly partial struct AcquireStorageAccountLock : IEquatable<AcquireStorageAccountLock>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcquireStorageAccountLock"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcquireStorageAccountLock(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcquireValue = "Acquire";
        private const string NotAcquireValue = "NotAcquire";

        /// <summary> Acquire. </summary>
        public static AcquireStorageAccountLock Acquire { get; } = new AcquireStorageAccountLock(AcquireValue);
        /// <summary> NotAcquire. </summary>
        public static AcquireStorageAccountLock NotAcquire { get; } = new AcquireStorageAccountLock(NotAcquireValue);
        /// <summary> Determines if two <see cref="AcquireStorageAccountLock"/> values are the same. </summary>
        public static bool operator ==(AcquireStorageAccountLock left, AcquireStorageAccountLock right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcquireStorageAccountLock"/> values are not the same. </summary>
        public static bool operator !=(AcquireStorageAccountLock left, AcquireStorageAccountLock right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcquireStorageAccountLock"/>. </summary>
        public static implicit operator AcquireStorageAccountLock(string value) => new AcquireStorageAccountLock(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcquireStorageAccountLock other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcquireStorageAccountLock other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
