// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServicesBackup
{
    /// <summary>
    /// A class representing a collection of <see cref="BackupEngineResource"/> and their operations.
    /// Each <see cref="BackupEngineResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="BackupEngineCollection"/> instance call the GetBackupEngines method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class BackupEngineCollection : ArmCollection, IEnumerable<BackupEngineResource>, IAsyncEnumerable<BackupEngineResource>
    {
        private readonly ClientDiagnostics _backupEngineClientDiagnostics;
        private readonly BackupEnginesRestOperations _backupEngineRestClient;
        private readonly string _vaultName;

        /// <summary> Initializes a new instance of the <see cref="BackupEngineCollection"/> class for mocking. </summary>
        protected BackupEngineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BackupEngineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="vaultName"> The name of the recovery services vault. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vaultName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="vaultName"/> is an empty string, and was expected to be non-empty. </exception>
        internal BackupEngineCollection(ArmClient client, ResourceIdentifier id, string vaultName) : base(client, id)
        {
            _vaultName = vaultName;
            _backupEngineClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.RecoveryServicesBackup", BackupEngineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(BackupEngineResource.ResourceType, out string backupEngineApiVersion);
            _backupEngineRestClient = new BackupEnginesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, backupEngineApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Returns backup management server registered to Recovery Services Vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual async Task<Response<BackupEngineResource>> GetAsync(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.Get");
            scope.Start();
            try
            {
                var response = await _backupEngineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BackupEngineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns backup management server registered to Recovery Services Vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual Response<BackupEngineResource> Get(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.Get");
            scope.Start();
            try
            {
                var response = _backupEngineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BackupEngineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Backup management servers registered to Recovery Services Vault. Returns a pageable list of servers.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="BackupEngineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<BackupEngineResource> GetAllAsync(string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _backupEngineRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, filter, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _backupEngineRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, _vaultName, filter, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new BackupEngineResource(Client, BackupEngineData.DeserializeBackupEngineData(e)), _backupEngineClientDiagnostics, Pipeline, "BackupEngineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Backup management servers registered to Recovery Services Vault. Returns a pageable list of servers.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="BackupEngineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<BackupEngineResource> GetAll(string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _backupEngineRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, filter, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _backupEngineRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, _vaultName, filter, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new BackupEngineResource(Client, BackupEngineData.DeserializeBackupEngineData(e)), _backupEngineClientDiagnostics, Pipeline, "BackupEngineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _backupEngineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual Response<bool> Exists(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.Exists");
            scope.Start();
            try
            {
                var response = _backupEngineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual async Task<NullableResponse<BackupEngineResource>> GetIfExistsAsync(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _backupEngineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<BackupEngineResource>(response.GetRawResponse());
                return Response.FromValue(new BackupEngineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupEngines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BackupEngineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="backupEngineName"> Name of the backup management server. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="backupEngineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="backupEngineName"/> is null. </exception>
        public virtual NullableResponse<BackupEngineResource> GetIfExists(string backupEngineName, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(backupEngineName, nameof(backupEngineName));

            using var scope = _backupEngineClientDiagnostics.CreateScope("BackupEngineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _backupEngineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _vaultName, backupEngineName, filter, skipToken, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<BackupEngineResource>(response.GetRawResponse());
                return Response.FromValue(new BackupEngineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<BackupEngineResource> IEnumerable<BackupEngineResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<BackupEngineResource> IAsyncEnumerable<BackupEngineResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
