// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using System.Xml;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesBackup.Models;

namespace Azure.ResourceManager.RecoveryServicesBackup.Samples
{
    public partial class Sample_BackupRecoveryPointResource
    {
        // Trigger RP Move Operation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MoveRecoveryPoint_TriggerRPMoveOperation()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/TriggerRecoveryPointMove_Post.json
            // this example is just showing the usage of "MoveRecoveryPoint" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            MoveRPAcrossTiersContent content = new MoveRPAcrossTiersContent()
            {
                ObjectType = "MoveRPAcrossTiersRequest",
                SourceTierType = RecoveryPointTierType.HardenedRP,
                TargetTierType = RecoveryPointTierType.ArchivedRP,
            };
            await backupRecoveryPoint.MoveRecoveryPointAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Get Azure Vm Recovery Point Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureVmRecoveryPointDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/RecoveryPoints_Get.json
            // this example is just showing the usage of "RecoveryPoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rshhtestmdvmrg";
            string vaultName = "rshvault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;rshhtestmdvmrg;rshmdvmsmall";
            string protectedItemName = "VM;iaasvmcontainerv2;rshhtestmdvmrg;rshmdvmsmall";
            string recoveryPointId = "26083826328862";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            BackupRecoveryPointResource result = await backupRecoveryPoint.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupRecoveryPointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Restore Disks with IaasVMRestoreRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreDisksWithIaasVMRestoreRequest()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_RestoreDisks_IaasVMRestoreRequest.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreContent()
                {
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.RestoreDisks,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    StorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testingRg/providers/Microsoft.Storage/storageAccounts/testAccount"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = true,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                    IdentityInfo = new BackupIdentityInfo()
                    {
                        IsSystemAssignedIdentity = false,
                        ManagedIdentityResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/asmaskarRG1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/asmaskartestmsi"),
                    },
                    TargetDiskNetworkAccessSettings = new BackupTargetDiskNetworkAccessSettings()
                    {
                        TargetDiskNetworkAccessOption = BackupTargetDiskNetworkAccessOption.EnablePrivateAccessForAllDisks,
                        TargetDiskAccessId = new ResourceIdentifier("/subscriptions/e7a191f5-713c-4bdb-b5e4-cf3dd90230ef/resourceGroups/arpja/providers/Microsoft.Compute/diskAccesses/arpja-diskaccess-ccy"),
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Restore Disks with IaasVMRestoreRequest with IdentityBasedRestoreDetails
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreDisksWithIaasVMRestoreRequestWithIdentityBasedRestoreDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_RestoreDisks_IaasVMRestoreRequest_IdentityBasedRestoreDetails.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreContent()
                {
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.RestoreDisks,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = true,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                    IdentityInfo = new BackupIdentityInfo()
                    {
                        IsSystemAssignedIdentity = false,
                        ManagedIdentityResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/asmaskarRG1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/asmaskartestmsi"),
                    },
                    IdentityBasedRestoreDetails = new IdentityBasedRestoreDetails()
                    {
                        TargetStorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testingRg/providers/Microsoft.Storage/storageAccounts/testAccount"),
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Restore Disks with IaasVMRestoreWithRehydrationRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreDisksWithIaasVMRestoreWithRehydrationRequest()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_RestoreDisks_IaasVMRestoreWithRehydrationRequest.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreWithRehydrationContent()
                {
                    RecoveryPointRehydrationInfo = new RecoveryPointRehydrationInfo()
                    {
                        RehydrationRetentionDuration = XmlConvert.ToTimeSpan("P7D"),
                        RehydrationPriority = RehydrationPriority.Standard,
                    },
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.RestoreDisks,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    StorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testingRg/providers/Microsoft.Storage/storageAccounts/testAccount"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = true,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Restore to New Azure IaasVm with IaasVMRestoreRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreToNewAzureIaasVmWithIaasVMRestoreRequest()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_ALR_IaasVMRestoreRequest.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreContent()
                {
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.AlternateLocation,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    TargetVirtualMachineId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2/providers/Microsoft.Compute/virtualmachines/RSMDALRVM981435"),
                    TargetResourceGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2"),
                    StorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Storage/storageAccounts/testingAccount"),
                    VirtualNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet"),
                    SubnetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet/subnets/default"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = false,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                    IdentityInfo = new BackupIdentityInfo()
                    {
                        IsSystemAssignedIdentity = true,
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Restore to New Azure IaasVm with IaasVMRestoreRequest with identityBasedRestoreDetails
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreToNewAzureIaasVmWithIaasVMRestoreRequestWithIdentityBasedRestoreDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_ALR_IaasVMRestoreRequest_IdentityBasedRestoreDetails.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreContent()
                {
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.AlternateLocation,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    TargetVirtualMachineId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2/providers/Microsoft.Compute/virtualmachines/RSMDALRVM981435"),
                    TargetResourceGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2"),
                    VirtualNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet"),
                    SubnetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet/subnets/default"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = false,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                    IdentityInfo = new BackupIdentityInfo()
                    {
                        IsSystemAssignedIdentity = true,
                    },
                    IdentityBasedRestoreDetails = new IdentityBasedRestoreDetails()
                    {
                        TargetStorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Storage/storageAccounts/testingAccount"),
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Restore to New Azure IaasVm with IaasVMRestoreWithRehydrationRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerRestore_RestoreToNewAzureIaasVmWithIaasVMRestoreWithRehydrationRequest()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/TriggerRestore_ALR_IaasVMRestoreWithRehydrationRequest.json
            // this example is just showing the usage of "Restores_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "netsdktestrg";
            string vaultName = "testVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string recoveryPointId = "348916168024334";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            TriggerRestoreContent content = new TriggerRestoreContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmRestoreWithRehydrationContent()
                {
                    RecoveryPointRehydrationInfo = new RecoveryPointRehydrationInfo()
                    {
                        RehydrationRetentionDuration = XmlConvert.ToTimeSpan("P7D"),
                        RehydrationPriority = RehydrationPriority.High,
                    },
                    RecoveryPointId = "348916168024334",
                    RecoveryType = FileShareRecoveryType.AlternateLocation,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    TargetVirtualMachineId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2/providers/Microsoft.Compute/virtualmachines/RSMDALRVM981435"),
                    TargetResourceGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg2"),
                    StorageAccountId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Storage/storageAccounts/testingAccount"),
                    VirtualNetworkId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet"),
                    SubnetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Network/virtualNetworks/testNet/subnets/default"),
                    Region = new AzureLocation("southeastasia"),
                    DoesCreateNewCloudService = false,
                    OriginalStorageAccountOption = false,
                    EncryptionDetails = new VmEncryptionDetails()
                    {
                        IsEncryptionEnabled = false,
                    },
                },
            };
            await backupRecoveryPoint.TriggerRestoreAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }

        // Provision Instant Item Level Recovery for Azure Vm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ProvisionItemLevelRecoveryConnection_ProvisionInstantItemLevelRecoveryForAzureVm()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/Provision_Ilr.json
            // this example is just showing the usage of "ItemLevelRecoveryConnections_Provision" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "PythonSDKBackupTestRg";
            string vaultName = "PySDKBackupTestRsVault";
            string fabricName = "Azure";
            string containerName = "iaasvmcontainer;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            string protectedItemName = "vm;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            string recoveryPointId = "1";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            ProvisionIlrConnectionContent content = new ProvisionIlrConnectionContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmIlrRegistrationContent()
                {
                    RecoveryPointId = "38823086363464",
                    VirtualMachineId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/pysdktestrg/providers/Microsoft.Compute/virtualMachines/pysdktestv2vm1"),
                    InitiatorName = "Hello World",
                    RenewExistingRegistration = true,
                },
            };
            await backupRecoveryPoint.ProvisionItemLevelRecoveryConnectionAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // Revoke Instant Item Level Recovery for Azure Vm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RevokeItemLevelRecoveryConnection_RevokeInstantItemLevelRecoveryForAzureVm()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/Revoke_Ilr.json
            // this example is just showing the usage of "ItemLevelRecoveryConnections_Revoke" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupRecoveryPointResource created on azure
            // for more information of creating BackupRecoveryPointResource, please refer to the document of BackupRecoveryPointResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "PythonSDKBackupTestRg";
            string vaultName = "PySDKBackupTestRsVault";
            string fabricName = "Azure";
            string containerName = "iaasvmcontainer;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            string protectedItemName = "vm;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            string recoveryPointId = "1";
            ResourceIdentifier backupRecoveryPointResourceId = BackupRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName, recoveryPointId);
            BackupRecoveryPointResource backupRecoveryPoint = client.GetBackupRecoveryPointResource(backupRecoveryPointResourceId);

            // invoke the operation
            await backupRecoveryPoint.RevokeItemLevelRecoveryConnectionAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
