// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesBackup.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServicesBackup.Samples
{
    public partial class Sample_BackupProtectionPolicyCollection
    {
        // List protection policies with backupManagementType filter as AzureIaasVm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListProtectionPoliciesWithBackupManagementTypeFilterAsAzureIaasVm()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/BackupPolicies_List.json
            // this example is just showing the usage of "BackupPolicies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation and iterate over the result
            string filter = "backupManagementType eq 'AzureIaasVM'";
            await foreach (BackupProtectionPolicyResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupProtectionPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List protection policies with backupManagementType filter as AzureIaasVm with both V1 and V2 policies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListProtectionPoliciesWithBackupManagementTypeFilterAsAzureIaasVmWithBothV1AndV2Policies()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/v2-List-Policies.json
            // this example is just showing the usage of "BackupPolicies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation and iterate over the result
            string filter = "backupManagementType eq 'AzureIaasVM'";
            await foreach (BackupProtectionPolicyResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupProtectionPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List protection policies with backupManagementType filter as AzureWorkload
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListProtectionPoliciesWithBackupManagementTypeFilterAsAzureWorkload()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureWorkload/BackupPolicies_List.json
            // this example is just showing the usage of "BackupPolicies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation and iterate over the result
            string filter = "backupManagementType eq 'AzureWorkload'";
            await foreach (BackupProtectionPolicyResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupProtectionPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Azure IaasVm Enhanced Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureIaasVmEnhancedProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/v2-Get-Policy.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "v2-daily-sample";
            BackupProtectionPolicyResource result = await collection.GetAsync(policyName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure IaasVm Enhanced Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureIaasVmEnhancedProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/v2-Get-Policy.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "v2-daily-sample";
            bool result = await collection.ExistsAsync(policyName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure IaasVm Enhanced Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureIaasVmEnhancedProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/v2-Get-Policy.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "v2-daily-sample";
            NullableResponse<BackupProtectionPolicyResource> response = await collection.GetIfExistsAsync(policyName);
            BackupProtectionPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupProtectionPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Azure IaasVm Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureIaasVmProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_Get.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            BackupProtectionPolicyResource result = await collection.GetAsync(policyName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Azure IaasVm Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureIaasVmProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_Get.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            bool result = await collection.ExistsAsync(policyName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Azure IaasVm Protection Policy Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureIaasVmProtectionPolicyDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_Get.json
            // this example is just showing the usage of "ProtectionPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            NullableResponse<BackupProtectionPolicyResource> response = await collection.GetIfExistsAsync(policyName);
            BackupProtectionPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupProtectionPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or Update Azure Storage Vault Standard Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAzureStorageVaultStandardProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Hardened.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "swaggertestvault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "newPolicyV2";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new FileShareProtectionPolicy()
                {
                    WorkLoadType = BackupWorkloadType.AzureFileShare,
                    SchedulePolicy = new SimpleSchedulePolicy()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Daily,
                        ScheduleRunTimes =
{
DateTimeOffset.Parse("2023-07-18T09:30:00.000Z")
},
                    },
                    VaultRetentionPolicy = new VaultRetentionPolicy(new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
DateTimeOffset.Parse("2023-07-18T09:30:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 30,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                            RetentionTimes =
{
DateTimeOffset.Parse("2023-07-18T09:30:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 12,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2023-07-18T09:30:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 60,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.January
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2023-07-18T09:30:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 10,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    }, 5),
                    TimeZone = "UTC",
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Daily Azure Storage Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateDailyAzureStorageProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Daily.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "swaggertestvault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "dailyPolicy2";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new FileShareProtectionPolicy()
                {
                    WorkLoadType = BackupWorkloadType.AzureFileShare,
                    SchedulePolicy = new SimpleSchedulePolicy()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Daily,
                        ScheduleRunTimes =
{
DateTimeOffset.Parse("2021-09-29T08:00:00.000Z")
},
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-09-29T08:00:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 5,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-09-29T08:00:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 12,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-09-29T08:00:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 60,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.January
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-09-29T08:00:00.000Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 10,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    },
                    TimeZone = "UTC",
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Enhanced Azure Vm Protection Policy with Hourly backup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateEnhancedAzureVmProtectionPolicyWithHourlyBackup()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/IaaS_v2_hourly.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "v2-daily-sample";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmProtectionPolicy()
                {
                    SchedulePolicy = new SimpleSchedulePolicyV2()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Hourly,
                        HourlySchedule = new BackupHourlySchedule()
                        {
                            Interval = 4,
                            ScheduleWindowStartOn = DateTimeOffset.Parse("2021-12-17T08:00:00Z"),
                            ScheduleWindowDuration = 16,
                        },
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 180,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 12,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 60,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.January
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 10,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    },
                    InstantRPRetentionRangeInDays = 30,
                    TimeZone = "India Standard Time",
                    PolicyType = IaasVmPolicyType.V2,
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Enhanced Azure Vm Protection Policy with daily backup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateEnhancedAzureVmProtectionPolicyWithDailyBackup()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/V2Policy/IaaS_v2_daily.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "v2-daily-sample";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmProtectionPolicy()
                {
                    SchedulePolicy = new SimpleSchedulePolicyV2()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Daily,
                        ScheduleRunTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 180,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 12,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 60,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.January
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2021-12-17T08:00:00+00:00")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 10,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    },
                    InstantRPRetentionRangeInDays = 30,
                    TimeZone = "India Standard Time",
                    PolicyType = IaasVmPolicyType.V2,
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Full Azure Vm Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateFullAzureVmProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_CreateOrUpdate_Complex.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmProtectionPolicy()
                {
                    SchedulePolicy = new SimpleSchedulePolicy()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Weekly,
                        ScheduleRunDays =
{
BackupDayOfWeek.Monday,BackupDayOfWeek.Wednesday,BackupDayOfWeek.Thursday
},
                        ScheduleRunTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Monday,BackupDayOfWeek.Wednesday,BackupDayOfWeek.Thursday
},
                            RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 1,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Wednesday,BackupDayOfWeek.Thursday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First,BackupWeekOfMonth.Third
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 2,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.February,BackupMonthOfYear.November
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Monday,BackupDayOfWeek.Thursday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.Fourth
},
                            },
                            RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 4,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    },
                    TimeZone = "Pacific Standard Time",
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Full Azure Workload Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateFullAzureWorkloadProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureWorkload/ProtectionPolicies_CreateOrUpdate_Complex.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new VmWorkloadProtectionPolicy()
                {
                    WorkLoadType = BackupWorkloadType.SqlDatabase,
                    Settings = new BackupCommonSettings()
                    {
                        TimeZone = "Pacific Standard Time",
                        IsSqlCompression = false,
                    },
                    SubProtectionPolicy =
{
new SubProtectionPolicy()
{
PolicyType = SubProtectionPolicyType.Full,
SchedulePolicy = new SimpleSchedulePolicy()
{
ScheduleRunFrequency = ScheduleRunType.Weekly,
ScheduleRunDays =
{
BackupDayOfWeek.Sunday,BackupDayOfWeek.Tuesday
},
ScheduleRunTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
},
RetentionPolicy = new LongTermRetentionPolicy()
{
WeeklySchedule = new WeeklyRetentionSchedule()
{
DaysOfTheWeek =
{
BackupDayOfWeek.Sunday,BackupDayOfWeek.Tuesday
},
RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
RetentionDuration = new RetentionDuration()
{
Count = 2,
DurationType = RetentionDurationType.Weeks,
},
},
MonthlySchedule = new MonthlyRetentionSchedule()
{
RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
RetentionScheduleWeekly = new WeeklyRetentionFormat()
{
DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
WeeksOfTheMonth =
{
BackupWeekOfMonth.Second
},
},
RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
RetentionDuration = new RetentionDuration()
{
Count = 1,
DurationType = RetentionDurationType.Months,
},
},
YearlySchedule = new YearlyRetentionSchedule()
{
RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
MonthsOfYear =
{
BackupMonthOfYear.January,BackupMonthOfYear.June,BackupMonthOfYear.December
},
RetentionScheduleWeekly = new WeeklyRetentionFormat()
{
DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
WeeksOfTheMonth =
{
BackupWeekOfMonth.Last
},
},
RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
RetentionDuration = new RetentionDuration()
{
Count = 1,
DurationType = RetentionDurationType.Years,
},
},
},
},new SubProtectionPolicy()
{
PolicyType = SubProtectionPolicyType.Differential,
SchedulePolicy = new SimpleSchedulePolicy()
{
ScheduleRunFrequency = ScheduleRunType.Weekly,
ScheduleRunDays =
{
BackupDayOfWeek.Friday
},
ScheduleRunTimes =
{
DateTimeOffset.Parse("2018-01-24T10:00:00Z")
},
},
RetentionPolicy = new SimpleRetentionPolicy()
{
RetentionDuration = new RetentionDuration()
{
Count = 8,
DurationType = RetentionDurationType.Days,
},
},
},new SubProtectionPolicy()
{
PolicyType = SubProtectionPolicyType.Log,
SchedulePolicy = new LogSchedulePolicy()
{
ScheduleFrequencyInMins = 60,
},
RetentionPolicy = new SimpleRetentionPolicy()
{
RetentionDuration = new RetentionDuration()
{
Count = 7,
DurationType = RetentionDurationType.Days,
},
},
}
},
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Hourly Azure Storage Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateHourlyAzureStorageProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureStorage/ProtectionPolicies_CreateOrUpdate_Hourly.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "swaggertestvault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "newPolicy2";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new FileShareProtectionPolicy()
                {
                    WorkLoadType = BackupWorkloadType.AzureFileShare,
                    SchedulePolicy = new SimpleSchedulePolicy()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Hourly,
                        HourlySchedule = new BackupHourlySchedule()
                        {
                            Interval = 4,
                            ScheduleWindowStartOn = DateTimeOffset.Parse("2021-09-29T08:00:00.000Z"),
                            ScheduleWindowDuration = 12,
                        },
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 5,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                        WeeklySchedule = new WeeklyRetentionSchedule()
                        {
                            DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                            RetentionTimes =
{
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 12,
                                DurationType = RetentionDurationType.Weeks,
                            },
                        },
                        MonthlySchedule = new MonthlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 60,
                                DurationType = RetentionDurationType.Months,
                            },
                        },
                        YearlySchedule = new YearlyRetentionSchedule()
                        {
                            RetentionScheduleFormatType = RetentionScheduleFormat.Weekly,
                            MonthsOfYear =
{
BackupMonthOfYear.January
},
                            RetentionScheduleWeekly = new WeeklyRetentionFormat()
                            {
                                DaysOfTheWeek =
{
BackupDayOfWeek.Sunday
},
                                WeeksOfTheMonth =
{
BackupWeekOfMonth.First
},
                            },
                            RetentionTimes =
{
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 10,
                                DurationType = RetentionDurationType.Years,
                            },
                        },
                    },
                    TimeZone = "UTC",
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Simple Azure Vm Protection Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateSimpleAzureVmProtectionPolicy()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ProtectionPolicies_CreateOrUpdate_Simple.json
            // this example is just showing the usage of "ProtectionPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this BackupProtectionPolicyResource
            string vaultName = "NetSDKTestRsVault";
            BackupProtectionPolicyCollection collection = resourceGroupResource.GetBackupProtectionPolicies(vaultName);

            // invoke the operation
            string policyName = "testPolicy1";
            BackupProtectionPolicyData data = new BackupProtectionPolicyData(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmProtectionPolicy()
                {
                    SchedulePolicy = new SimpleSchedulePolicy()
                    {
                        ScheduleRunFrequency = ScheduleRunType.Daily,
                        ScheduleRunTimes =
{
DateTimeOffset.Parse("2018-01-24T02:00:00Z")
},
                    },
                    RetentionPolicy = new LongTermRetentionPolicy()
                    {
                        DailySchedule = new DailyRetentionSchedule()
                        {
                            RetentionTimes =
{
DateTimeOffset.Parse("2018-01-24T02:00:00Z")
},
                            RetentionDuration = new RetentionDuration()
                            {
                                Count = 1,
                                DurationType = RetentionDurationType.Days,
                            },
                        },
                    },
                    TimeZone = "Pacific Standard Time",
                },
            };
            ArmOperation<BackupProtectionPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyName, data);
            BackupProtectionPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectionPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
