// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesBackup.Models;

namespace Azure.ResourceManager.RecoveryServicesBackup.Samples
{
    public partial class Sample_BackupProtectedItemResource
    {
        // Get Protected Classic Virtual Machine Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetProtectedClassicVirtualMachineDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ClassicCompute_ProtectedItem_Get.json
            // this example is just showing the usage of "ProtectedItems_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "PythonSDKBackupTestRg";
            string vaultName = "PySDKBackupTestRsVault";
            string fabricName = "Azure";
            string containerName = "iaasvmcontainer;iaasvmcontainer;iaasvm-rg;iaasvm-1";
            string protectedItemName = "vm;iaasvmcontainer;iaasvm-rg;iaasvm-1";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            BackupProtectedItemResource result = await backupProtectedItem.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Protected Virtual Machine Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetProtectedVirtualMachineDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/Compute_ProtectedItem_Get.json
            // this example is just showing the usage of "ProtectedItems_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "PythonSDKBackupTestRg";
            string vaultName = "PySDKBackupTestRsVault";
            string fabricName = "Azure";
            string containerName = "iaasvmcontainer;iaasvmcontainerv2;iaasvm-rg;iaasvm-1";
            string protectedItemName = "vm;iaasvmcontainerv2;iaasvm-rg;iaasvm-1";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            BackupProtectedItemResource result = await backupProtectedItem.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Enable Protection on Azure IaasVm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_EnableProtectionOnAzureIaasVm()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/ConfigureProtection.json
            // this example is just showing the usage of "ProtectedItems_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            string vaultName = "NetSDKTestRsVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            BackupProtectedItemData data = new BackupProtectedItemData(new AzureLocation("placeholder"))
            {
                Properties = new IaasComputeVmProtectedItem()
                {
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                    PolicyId = new ResourceIdentifier("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy"),
                },
            };
            ArmOperation<BackupProtectedItemResource> lro = await backupProtectedItem.UpdateAsync(WaitUntil.Completed, data);
            BackupProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Stop Protection with retain data on Azure IaasVm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StopProtectionWithRetainDataOnAzureIaasVm()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/StopProtection.json
            // this example is just showing the usage of "ProtectedItems_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "SwaggerTestRg";
            string vaultName = "NetSDKTestRsVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            string protectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            BackupProtectedItemData data = new BackupProtectedItemData(new AzureLocation("placeholder"))
            {
                Properties = new IaasComputeVmProtectedItem()
                {
                    ProtectionState = BackupProtectionState.ProtectionStopped,
                    SourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1"),
                },
            };
            ArmOperation<BackupProtectedItemResource> lro = await backupProtectedItem.UpdateAsync(WaitUntil.Completed, data);
            BackupProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Protection from Azure Virtual Machine
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteProtectionFromAzureVirtualMachine()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/Common/ProtectedItem_Delete.json
            // this example is just showing the usage of "ProtectedItems_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "PythonSDKBackupTestRg";
            string vaultName = "PySDKBackupTestRsVault";
            string fabricName = "Azure";
            string containerName = "iaasvmcontainer;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            string protectedItemName = "vm;iaasvmcontainerv2;pysdktestrg;pysdktestv2vm1";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            await backupProtectedItem.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Trigger Backup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TriggerBackup_TriggerBackup()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/Common/TriggerBackup_Post.json
            // this example is just showing the usage of "Backups_Trigger" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "linuxRsVaultRG";
            string vaultName = "linuxRsVault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;testrg;v1win2012r";
            string protectedItemName = "VM;iaasvmcontainerv2;testrg;v1win2012r";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation
            TriggerBackupContent content = new TriggerBackupContent(new AzureLocation("placeholder"))
            {
                Properties = new IaasVmBackupContent(),
            };
            await backupProtectedItem.TriggerBackupAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // Get Protected Azure Vm Recovery Points Recommended for Move
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRecoveryPointsRecommendedForMove_GetProtectedAzureVmRecoveryPointsRecommendedForMove()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/RecoveryPointsRecommendedForMove_List.json
            // this example is just showing the usage of "RecoveryPointsRecommendedForMove_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupProtectedItemResource created on azure
            // for more information of creating BackupProtectedItemResource, please refer to the document of BackupProtectedItemResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rshhtestmdvmrg";
            string vaultName = "rshvault";
            string fabricName = "Azure";
            string containerName = "IaasVMContainer;iaasvmcontainerv2;rshhtestmdvmrg;rshmdvmsmall";
            string protectedItemName = "VM;iaasvmcontainerv2;rshhtestmdvmrg;rshmdvmsmall";
            ResourceIdentifier backupProtectedItemResourceId = BackupProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, fabricName, containerName, protectedItemName);
            BackupProtectedItemResource backupProtectedItem = client.GetBackupProtectedItemResource(backupProtectedItemResourceId);

            // invoke the operation and iterate over the result
            RecoveryPointsRecommendedForMoveContent content = new RecoveryPointsRecommendedForMoveContent()
            {
                ObjectType = "ListRecoveryPointsRecommendedForMoveRequest",
                ExcludedRPList =
{
"348916168024334","348916168024335"
},
            };
            await foreach (BackupRecoveryPointResource item in backupProtectedItem.GetRecoveryPointsRecommendedForMoveAsync(content))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BackupRecoveryPointData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
