// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RecoveryServicesBackup.Samples
{
    public partial class Sample_BackupEngineResource
    {
        // Get Dpm/AzureBackupServer/Lajolla Backup Engine Details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDpmAzureBackupServerLajollaBackupEngineDetails()
        {
            // Generated from example definition: specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/Dpm/BackupEngines_Get.json
            // this example is just showing the usage of "BackupEngines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BackupEngineResource created on azure
            // for more information of creating BackupEngineResource, please refer to the document of BackupEngineResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "testRG";
            string vaultName = "testVault";
            string backupEngineName = "testServer";
            ResourceIdentifier backupEngineResourceId = BackupEngineResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, backupEngineName);
            BackupEngineResource backupEngine = client.GetBackupEngineResource(backupEngineResourceId);

            // invoke the operation
            BackupEngineResource result = await backupEngine.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BackupEngineData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
