// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ManagementGroups;

namespace Azure.ResourceManager.Quota
{
    /// <summary>
    /// A class representing a collection of <see cref="SubscriptionQuotaAllocationResource"/> and their operations.
    /// Each <see cref="SubscriptionQuotaAllocationResource"/> in the collection will belong to the same instance of <see cref="ManagementGroupResource"/>.
    /// To get a <see cref="SubscriptionQuotaAllocationCollection"/> instance call the GetSubscriptionQuotaAllocations method from an instance of <see cref="ManagementGroupResource"/>.
    /// </summary>
    public partial class SubscriptionQuotaAllocationCollection : ArmCollection
    {
        private readonly ClientDiagnostics _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics;
        private readonly GroupQuotaSubscriptionAllocationRestOperations _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient;
        private readonly string _subscriptionId;
        private readonly string _groupQuotaName;

        /// <summary> Initializes a new instance of the <see cref="SubscriptionQuotaAllocationCollection"/> class for mocking. </summary>
        protected SubscriptionQuotaAllocationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SubscriptionQuotaAllocationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. The value must be an UUID. </param>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="groupQuotaName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        internal SubscriptionQuotaAllocationCollection(ArmClient client, ResourceIdentifier id, string subscriptionId, string groupQuotaName) : base(client, id)
        {
            _subscriptionId = subscriptionId;
            _groupQuotaName = groupQuotaName;
            _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Quota", SubscriptionQuotaAllocationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SubscriptionQuotaAllocationResource.ResourceType, out string subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationApiVersion);
            _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient = new GroupQuotaSubscriptionAllocationRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ManagementGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ManagementGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets Quota allocated to a subscription for the specific Resource Provider, Location, ResourceName. This will include the GroupQuota and total quota allocated to the subscription. Only the Group quota allocated to the subscription can be allocated back to the MG Group Quota.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual async Task<Response<SubscriptionQuotaAllocationResource>> GetAsync(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.Get");
            scope.Start();
            try
            {
                var response = await _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.GetAsync(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SubscriptionQuotaAllocationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets Quota allocated to a subscription for the specific Resource Provider, Location, ResourceName. This will include the GroupQuota and total quota allocated to the subscription. Only the Group quota allocated to the subscription can be allocated back to the MG Group Quota.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual Response<SubscriptionQuotaAllocationResource> Get(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.Get");
            scope.Start();
            try
            {
                var response = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.Get(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SubscriptionQuotaAllocationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all the quota allocated to a subscription for the specific Resource Provider, Location. This will include the GroupQuota and total quota allocated to the subscription. Only the Group quota allocated to the subscription can be allocated back to the MG Group Quota. Use the $filter parameter to filter out the specific resource based on the ResourceProvider/Location. $filter is a required parameter.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filter"/> is null. </exception>
        /// <returns> An async collection of <see cref="SubscriptionQuotaAllocationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SubscriptionQuotaAllocationResource> GetAllAsync(string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(filter, nameof(filter));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.CreateListRequest(Id.Name, _subscriptionId, _groupQuotaName, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.CreateListNextPageRequest(nextLink, Id.Name, _subscriptionId, _groupQuotaName, filter);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SubscriptionQuotaAllocationResource(Client, SubscriptionQuotaAllocationData.DeserializeSubscriptionQuotaAllocationData(e)), _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics, Pipeline, "SubscriptionQuotaAllocationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all the quota allocated to a subscription for the specific Resource Provider, Location. This will include the GroupQuota and total quota allocated to the subscription. Only the Group quota allocated to the subscription can be allocated back to the MG Group Quota. Use the $filter parameter to filter out the specific resource based on the ResourceProvider/Location. $filter is a required parameter.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filter"/> is null. </exception>
        /// <returns> A collection of <see cref="SubscriptionQuotaAllocationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SubscriptionQuotaAllocationResource> GetAll(string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(filter, nameof(filter));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.CreateListRequest(Id.Name, _subscriptionId, _groupQuotaName, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.CreateListNextPageRequest(nextLink, Id.Name, _subscriptionId, _groupQuotaName, filter);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SubscriptionQuotaAllocationResource(Client, SubscriptionQuotaAllocationData.DeserializeSubscriptionQuotaAllocationData(e)), _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics, Pipeline, "SubscriptionQuotaAllocationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.GetAsync(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual Response<bool> Exists(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.Exists");
            scope.Start();
            try
            {
                var response = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.Get(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual async Task<NullableResponse<SubscriptionQuotaAllocationResource>> GetIfExistsAsync(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.GetAsync(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SubscriptionQuotaAllocationResource>(response.GetRawResponse());
                return Response.FromValue(new SubscriptionQuotaAllocationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionAllocation_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionQuotaAllocationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="filter">
        /// | Field | Supported operators
        /// |---------------------|------------------------
        ///
        ///  location eq {location}
        ///  Example: $filter=location eq eastus
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceName"/> or <paramref name="filter"/> is null. </exception>
        public virtual NullableResponse<SubscriptionQuotaAllocationResource> GetIfExists(string resourceName, string filter, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceName, nameof(resourceName));
            Argument.AssertNotNull(filter, nameof(filter));

            using var scope = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationClientDiagnostics.CreateScope("SubscriptionQuotaAllocationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _subscriptionQuotaAllocationGroupQuotaSubscriptionAllocationRestClient.Get(Id.Name, _subscriptionId, _groupQuotaName, resourceName, filter, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SubscriptionQuotaAllocationResource>(response.GetRawResponse());
                return Response.FromValue(new SubscriptionQuotaAllocationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
