// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Quota.Models;

namespace Azure.ResourceManager.Quota
{
    /// <summary>
    /// A class representing the QuotaRequestDetail data model.
    /// List of quota requests with details.
    /// </summary>
    public partial class QuotaRequestDetailData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QuotaRequestDetailData"/>. </summary>
        internal QuotaRequestDetailData()
        {
            Value = new ChangeTrackingList<QuotaSubRequestDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="QuotaRequestDetailData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> The quota request status. </param>
        /// <param name="message"> User-friendly status message. </param>
        /// <param name="error"> Error details of the quota request. </param>
        /// <param name="requestSubmitOn"> The quota request submission time. The date conforms to the following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ. </param>
        /// <param name="value"> Quota request details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QuotaRequestDetailData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, QuotaRequestState? provisioningState, string message, ServiceErrorDetail error, DateTimeOffset? requestSubmitOn, IReadOnlyList<QuotaSubRequestDetail> value, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            Message = message;
            Error = error;
            RequestSubmitOn = requestSubmitOn;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The quota request status. </summary>
        [WirePath("properties.provisioningState")]
        public QuotaRequestState? ProvisioningState { get; }
        /// <summary> User-friendly status message. </summary>
        [WirePath("properties.message")]
        public string Message { get; }
        /// <summary> Error details of the quota request. </summary>
        [WirePath("properties.error")]
        public ServiceErrorDetail Error { get; }
        /// <summary> The quota request submission time. The date conforms to the following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ. </summary>
        [WirePath("properties.requestSubmitTime")]
        public DateTimeOffset? RequestSubmitOn { get; }
        /// <summary> Quota request details. </summary>
        [WirePath("properties.value")]
        public IReadOnlyList<QuotaSubRequestDetail> Value { get; }
    }
}
