// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> SubscriptionIds and quota allocated to subscriptions from the GroupQuota. </summary>
    public partial class SubscriptionAllocatedQuota
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubscriptionAllocatedQuota"/>. </summary>
        internal SubscriptionAllocatedQuota()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SubscriptionAllocatedQuota"/>. </summary>
        /// <param name="subscriptionId"> An Azure subscriptionId. </param>
        /// <param name="quotaAllocated"> The amount of quota allocated to this subscriptionId from the GroupQuotasEntity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubscriptionAllocatedQuota(string subscriptionId, long? quotaAllocated, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubscriptionId = subscriptionId;
            QuotaAllocated = quotaAllocated;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An Azure subscriptionId. </summary>
        [WirePath("subscriptionId")]
        public string SubscriptionId { get; }
        /// <summary> The amount of quota allocated to this subscriptionId from the GroupQuotasEntity. </summary>
        [WirePath("quotaAllocated")]
        public long? QuotaAllocated { get; }
    }
}
