// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The quota or usages limit types. </summary>
    public readonly partial struct QuotaUsagesType : IEquatable<QuotaUsagesType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QuotaUsagesType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QuotaUsagesType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IndividualValue = "Individual";
        private const string CombinedValue = "Combined";

        /// <summary> Individual. </summary>
        public static QuotaUsagesType Individual { get; } = new QuotaUsagesType(IndividualValue);
        /// <summary> Combined. </summary>
        public static QuotaUsagesType Combined { get; } = new QuotaUsagesType(CombinedValue);
        /// <summary> Determines if two <see cref="QuotaUsagesType"/> values are the same. </summary>
        public static bool operator ==(QuotaUsagesType left, QuotaUsagesType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QuotaUsagesType"/> values are not the same. </summary>
        public static bool operator !=(QuotaUsagesType left, QuotaUsagesType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QuotaUsagesType"/>. </summary>
        public static implicit operator QuotaUsagesType(string value) => new QuotaUsagesType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QuotaUsagesType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QuotaUsagesType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
