// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The resource usages value. </summary>
    public partial class QuotaUsagesObject
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QuotaUsagesObject"/>. </summary>
        /// <param name="value"> The usages value. </param>
        internal QuotaUsagesObject(int value)
        {
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="QuotaUsagesObject"/>. </summary>
        /// <param name="value"> The usages value. </param>
        /// <param name="usagesType"> The quota or usages limit types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QuotaUsagesObject(int value, QuotaUsagesType? usagesType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            UsagesType = usagesType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="QuotaUsagesObject"/> for deserialization. </summary>
        internal QuotaUsagesObject()
        {
        }

        /// <summary> The usages value. </summary>
        [WirePath("value")]
        public int Value { get; }
        /// <summary> The quota or usages limit types. </summary>
        [WirePath("usagesType")]
        public QuotaUsagesType? UsagesType { get; }
    }
}
