// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified. </summary>
    public partial class GroupQuotasEntityBasePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotasEntityBasePatch"/>. </summary>
        public GroupQuotasEntityBasePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotasEntityBasePatch"/>. </summary>
        /// <param name="displayName"> Display name of the GroupQuota entity. </param>
        /// <param name="additionalAttributes"> Additional attributes to filter/restrict the subscriptions, which can be added to the subscriptionIds. </param>
        /// <param name="provisioningState"> Provisioning state of the operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotasEntityBasePatch(string displayName, GroupQuotaAdditionalAttributesPatch additionalAttributes, QuotaRequestStatus? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            AdditionalAttributes = additionalAttributes;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the GroupQuota entity. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
        /// <summary> Additional attributes to filter/restrict the subscriptions, which can be added to the subscriptionIds. </summary>
        [WirePath("additionalAttributes")]
        public GroupQuotaAdditionalAttributesPatch AdditionalAttributes { get; set; }
        /// <summary> Provisioning state of the operation. </summary>
        [WirePath("provisioningState")]
        public QuotaRequestStatus? ProvisioningState { get; }
    }
}
