// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> Resource details with usages and GroupQuota. </summary>
    public partial class GroupQuotaUsagesBase
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaUsagesBase"/>. </summary>
        public GroupQuotaUsagesBase()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaUsagesBase"/>. </summary>
        /// <param name="limit"> Quota/limits for the resource. </param>
        /// <param name="usages"> Usages for the resource. </param>
        /// <param name="unit"> Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond. Based on - https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages . Different RPs may have different units, Count, type as int64 should work for most of the integer values. </param>
        /// <param name="value"> Resource name. </param>
        /// <param name="localizedValue"> Resource display name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaUsagesBase(long? limit, long? usages, string unit, string value, string localizedValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Limit = limit;
            Usages = usages;
            Unit = unit;
            Value = value;
            LocalizedValue = localizedValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Quota/limits for the resource. </summary>
        [WirePath("limit")]
        public long? Limit { get; set; }
        /// <summary> Usages for the resource. </summary>
        [WirePath("usages")]
        public long? Usages { get; set; }
        /// <summary> Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond. Based on - https://armwiki.azurewebsites.net/api_contracts/UsagesAPIContract.html?q=usages . Different RPs may have different units, Count, type as int64 should work for most of the integer values. </summary>
        [WirePath("unit")]
        public string Unit { get; }
        /// <summary> Resource name. </summary>
        [WirePath("name.value")]
        public string Value { get; set; }
        /// <summary> Resource display name. </summary>
        [WirePath("name.localizedValue")]
        public string LocalizedValue { get; }
    }
}
