// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The GroupQuotaSubscriptionProperties. </summary>
    public partial class GroupQuotaSubscriptionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaSubscriptionProperties"/>. </summary>
        public GroupQuotaSubscriptionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaSubscriptionProperties"/>. </summary>
        /// <param name="subscriptionId"> An Azure subscriptionId. </param>
        /// <param name="provisioningState"> Status of this subscriptionId being associated with the GroupQuotasEntity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaSubscriptionProperties(string subscriptionId, QuotaRequestStatus? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubscriptionId = subscriptionId;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An Azure subscriptionId. </summary>
        [WirePath("subscriptionId")]
        public string SubscriptionId { get; }
        /// <summary> Status of this subscriptionId being associated with the GroupQuotasEntity. </summary>
        [WirePath("provisioningState")]
        public QuotaRequestStatus? ProvisioningState { get; }
    }
}
