// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The new GroupQuota limit requested. </summary>
    public partial class GroupQuotaRequestBase
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaRequestBase"/>. </summary>
        public GroupQuotaRequestBase()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaRequestBase"/>. </summary>
        /// <param name="limit"> The new quota limit for the subscription. The incremental quota will be allocated from pre-approved group quota. </param>
        /// <param name="region"> Location/Azure region for the quota requested for resource. </param>
        /// <param name="comments"> GroupQuota Request comments and details for request. This is optional paramter to provide more details related to the requested resource. </param>
        /// <param name="value"> Resource name. </param>
        /// <param name="localizedValue"> Resource display name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaRequestBase(long? limit, string region, string comments, string value, string localizedValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Limit = limit;
            Region = region;
            Comments = comments;
            Value = value;
            LocalizedValue = localizedValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The new quota limit for the subscription. The incremental quota will be allocated from pre-approved group quota. </summary>
        [WirePath("properties.limit")]
        public long? Limit { get; set; }
        /// <summary> Location/Azure region for the quota requested for resource. </summary>
        [WirePath("properties.region")]
        public string Region { get; set; }
        /// <summary> GroupQuota Request comments and details for request. This is optional paramter to provide more details related to the requested resource. </summary>
        [WirePath("properties.comments")]
        public string Comments { get; set; }
        /// <summary> Resource name. </summary>
        [WirePath("properties.value")]
        public string Value { get; }
        /// <summary> Resource display name. </summary>
        [WirePath("properties.localizedValue")]
        public string LocalizedValue { get; }
    }
}
