// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The grouping Id for the group quota. It can be Billing Id or ServiceTreeId if applicable. </summary>
    public partial class GroupQuotaGroupingId
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaGroupingId"/>. </summary>
        public GroupQuotaGroupingId()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaGroupingId"/>. </summary>
        /// <param name="groupingIdType"> GroupingId type. It is a required property. More types of groupIds can be supported in future. </param>
        /// <param name="value"> GroupId value based on the groupingType selected - Billing Id or ServiceTreeId. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaGroupingId(GroupQuotaGroupingIdType? groupingIdType, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupingIdType = groupingIdType;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> GroupingId type. It is a required property. More types of groupIds can be supported in future. </summary>
        [WirePath("groupingIdType")]
        public GroupQuotaGroupingIdType? GroupingIdType { get; set; }
        /// <summary> GroupId value based on the groupingType selected - Billing Id or ServiceTreeId. </summary>
        [WirePath("value")]
        public string Value { get; set; }
    }
}
