// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> Enforcement status. </summary>
    public readonly partial struct GroupQuotaEnforcementState : IEquatable<GroupQuotaEnforcementState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaEnforcementState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GroupQuotaEnforcementState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string NotAvailableValue = "NotAvailable";

        /// <summary> Enabled. </summary>
        public static GroupQuotaEnforcementState Enabled { get; } = new GroupQuotaEnforcementState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static GroupQuotaEnforcementState Disabled { get; } = new GroupQuotaEnforcementState(DisabledValue);
        /// <summary> NotAvailable. </summary>
        public static GroupQuotaEnforcementState NotAvailable { get; } = new GroupQuotaEnforcementState(NotAvailableValue);
        /// <summary> Determines if two <see cref="GroupQuotaEnforcementState"/> values are the same. </summary>
        public static bool operator ==(GroupQuotaEnforcementState left, GroupQuotaEnforcementState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GroupQuotaEnforcementState"/> values are not the same. </summary>
        public static bool operator !=(GroupQuotaEnforcementState left, GroupQuotaEnforcementState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GroupQuotaEnforcementState"/>. </summary>
        public static implicit operator GroupQuotaEnforcementState(string value) => new GroupQuotaEnforcementState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GroupQuotaEnforcementState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GroupQuotaEnforcementState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
