// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> The GroupQuotaEnforcementProperties. </summary>
    public partial class GroupQuotaEnforcementProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaEnforcementProperties"/>. </summary>
        public GroupQuotaEnforcementProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaEnforcementProperties"/>. </summary>
        /// <param name="enforcementEnabled"> Is the GroupQuota Enforcement enabled for the Azure region. </param>
        /// <param name="provisioningState"> Request status. </param>
        /// <param name="faultCode"> Details of the failure. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaEnforcementProperties(GroupQuotaEnforcementState? enforcementEnabled, QuotaRequestStatus? provisioningState, string faultCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EnforcementEnabled = enforcementEnabled;
            ProvisioningState = provisioningState;
            FaultCode = faultCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Is the GroupQuota Enforcement enabled for the Azure region. </summary>
        [WirePath("enforcementEnabled")]
        public GroupQuotaEnforcementState? EnforcementEnabled { get; set; }
        /// <summary> Request status. </summary>
        [WirePath("provisioningState")]
        public QuotaRequestStatus? ProvisioningState { get; }
        /// <summary> Details of the failure. </summary>
        [WirePath("faultCode")]
        public string FaultCode { get; }
    }
}
