// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quota.Models
{
    /// <summary> Additional attribute or filter to allow subscriptions meeting the requirements to be part of the GroupQuota. </summary>
    public partial class GroupQuotaAdditionalAttributesPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupQuotaAdditionalAttributesPatch"/>. </summary>
        public GroupQuotaAdditionalAttributesPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GroupQuotaAdditionalAttributesPatch"/>. </summary>
        /// <param name="groupId"> The grouping Id for the group quota. It can be Billing Id or ServiceTreeId if applicable. </param>
        /// <param name="environment"> Environment name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupQuotaAdditionalAttributesPatch(GroupQuotaGroupingId groupId, GroupQuotaEnvironmentType? environment, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupId = groupId;
            Environment = environment;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The grouping Id for the group quota. It can be Billing Id or ServiceTreeId if applicable. </summary>
        [WirePath("groupId")]
        public GroupQuotaGroupingId GroupId { get; set; }
        /// <summary> Environment name. </summary>
        [WirePath("environment")]
        public GroupQuotaEnvironmentType? Environment { get; set; }
    }
}
