// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Quota
{
    internal class QuotaAllocationRequestStatusOperationSource : IOperationSource<QuotaAllocationRequestStatusResource>
    {
        private readonly ArmClient _client;

        internal QuotaAllocationRequestStatusOperationSource(ArmClient client)
        {
            _client = client;
        }

        QuotaAllocationRequestStatusResource IOperationSource<QuotaAllocationRequestStatusResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = QuotaAllocationRequestStatusData.DeserializeQuotaAllocationRequestStatusData(document.RootElement);
            return new QuotaAllocationRequestStatusResource(_client, data);
        }

        async ValueTask<QuotaAllocationRequestStatusResource> IOperationSource<QuotaAllocationRequestStatusResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = QuotaAllocationRequestStatusData.DeserializeQuotaAllocationRequestStatusData(document.RootElement);
            return new QuotaAllocationRequestStatusResource(_client, data);
        }
    }
}
