// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Quota
{
    internal class GroupQuotaRequestStatusOperationSource : IOperationSource<GroupQuotaRequestStatusResource>
    {
        private readonly ArmClient _client;

        internal GroupQuotaRequestStatusOperationSource(ArmClient client)
        {
            _client = client;
        }

        GroupQuotaRequestStatusResource IOperationSource<GroupQuotaRequestStatusResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GroupQuotaRequestStatusData.DeserializeGroupQuotaRequestStatusData(document.RootElement);
            return new GroupQuotaRequestStatusResource(_client, data);
        }

        async ValueTask<GroupQuotaRequestStatusResource> IOperationSource<GroupQuotaRequestStatusResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GroupQuotaRequestStatusData.DeserializeGroupQuotaRequestStatusData(document.RootElement);
            return new GroupQuotaRequestStatusResource(_client, data);
        }
    }
}
