// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Quota
{
    internal class GroupQuotaEntityOperationSource : IOperationSource<GroupQuotaEntityResource>
    {
        private readonly ArmClient _client;

        internal GroupQuotaEntityOperationSource(ArmClient client)
        {
            _client = client;
        }

        GroupQuotaEntityResource IOperationSource<GroupQuotaEntityResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GroupQuotaEntityData.DeserializeGroupQuotaEntityData(document.RootElement);
            return new GroupQuotaEntityResource(_client, data);
        }

        async ValueTask<GroupQuotaEntityResource> IOperationSource<GroupQuotaEntityResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GroupQuotaEntityData.DeserializeGroupQuotaEntityData(document.RootElement);
            return new GroupQuotaEntityResource(_client, data);
        }
    }
}
