// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Quota
{
    internal class GroupQuotaEnforcementOperationSource : IOperationSource<GroupQuotaEnforcementResource>
    {
        private readonly ArmClient _client;

        internal GroupQuotaEnforcementOperationSource(ArmClient client)
        {
            _client = client;
        }

        GroupQuotaEnforcementResource IOperationSource<GroupQuotaEnforcementResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GroupQuotaEnforcementData.DeserializeGroupQuotaEnforcementData(document.RootElement);
            return new GroupQuotaEnforcementResource(_client, data);
        }

        async ValueTask<GroupQuotaEnforcementResource> IOperationSource<GroupQuotaEnforcementResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GroupQuotaEnforcementData.DeserializeGroupQuotaEnforcementData(document.RootElement);
            return new GroupQuotaEnforcementResource(_client, data);
        }
    }
}
