// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Quota
{
    internal class CurrentQuotaLimitBaseOperationSource : IOperationSource<CurrentQuotaLimitBaseResource>
    {
        private readonly ArmClient _client;

        internal CurrentQuotaLimitBaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        CurrentQuotaLimitBaseResource IOperationSource<CurrentQuotaLimitBaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CurrentQuotaLimitBaseData.DeserializeCurrentQuotaLimitBaseData(document.RootElement);
            return new CurrentQuotaLimitBaseResource(_client, data);
        }

        async ValueTask<CurrentQuotaLimitBaseResource> IOperationSource<CurrentQuotaLimitBaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CurrentQuotaLimitBaseData.DeserializeCurrentQuotaLimitBaseData(document.RootElement);
            return new CurrentQuotaLimitBaseResource(_client, data);
        }
    }
}
