// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Quota
{
    /// <summary>
    /// A class representing a collection of <see cref="GroupQuotaSubscriptionRequestStatusResource"/> and their operations.
    /// Each <see cref="GroupQuotaSubscriptionRequestStatusResource"/> in the collection will belong to the same instance of <see cref="GroupQuotaEntityResource"/>.
    /// To get a <see cref="GroupQuotaSubscriptionRequestStatusCollection"/> instance call the GetGroupQuotaSubscriptionRequestStatuses method from an instance of <see cref="GroupQuotaEntityResource"/>.
    /// </summary>
    public partial class GroupQuotaSubscriptionRequestStatusCollection : ArmCollection, IEnumerable<GroupQuotaSubscriptionRequestStatusResource>, IAsyncEnumerable<GroupQuotaSubscriptionRequestStatusResource>
    {
        private readonly ClientDiagnostics _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics;
        private readonly GroupQuotaSubscriptionRequestsRestOperations _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient;

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaSubscriptionRequestStatusCollection"/> class for mocking. </summary>
        protected GroupQuotaSubscriptionRequestStatusCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaSubscriptionRequestStatusCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal GroupQuotaSubscriptionRequestStatusCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Quota", GroupQuotaSubscriptionRequestStatusResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(GroupQuotaSubscriptionRequestStatusResource.ResourceType, out string groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsApiVersion);
            _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient = new GroupQuotaSubscriptionRequestsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != GroupQuotaEntityResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, GroupQuotaEntityResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get API to check the status of a subscriptionIds request by requestId.  Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with retry-after duration in seconds to check the intermediate status. This API provides the finals status with the request details and status.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual async Task<Response<GroupQuotaSubscriptionRequestStatusResource>> GetAsync(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.Get");
            scope.Start();
            try
            {
                var response = await _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.GetAsync(Id.Parent.Name, Id.Name, requestId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaSubscriptionRequestStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get API to check the status of a subscriptionIds request by requestId.  Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with retry-after duration in seconds to check the intermediate status. This API provides the finals status with the request details and status.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual Response<GroupQuotaSubscriptionRequestStatusResource> Get(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.Get");
            scope.Start();
            try
            {
                var response = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.Get(Id.Parent.Name, Id.Name, requestId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaSubscriptionRequestStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List API to check the status of a subscriptionId requests by requestId. Request history is maintained for 1 year.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="GroupQuotaSubscriptionRequestStatusResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<GroupQuotaSubscriptionRequestStatusResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.CreateListRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaSubscriptionRequestStatusResource(Client, GroupQuotaSubscriptionRequestStatusData.DeserializeGroupQuotaSubscriptionRequestStatusData(e)), _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics, Pipeline, "GroupQuotaSubscriptionRequestStatusCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List API to check the status of a subscriptionId requests by requestId. Request history is maintained for 1 year.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="GroupQuotaSubscriptionRequestStatusResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<GroupQuotaSubscriptionRequestStatusResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.CreateListRequest(Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaSubscriptionRequestStatusResource(Client, GroupQuotaSubscriptionRequestStatusData.DeserializeGroupQuotaSubscriptionRequestStatusData(e)), _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics, Pipeline, "GroupQuotaSubscriptionRequestStatusCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.Exists");
            scope.Start();
            try
            {
                var response = await _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.GetAsync(Id.Parent.Name, Id.Name, requestId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual Response<bool> Exists(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.Exists");
            scope.Start();
            try
            {
                var response = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.Get(Id.Parent.Name, Id.Name, requestId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual async Task<NullableResponse<GroupQuotaSubscriptionRequestStatusResource>> GetIfExistsAsync(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.GetAsync(Id.Parent.Name, Id.Name, requestId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaSubscriptionRequestStatusResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaSubscriptionRequestStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaSubscriptionRequests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaSubscriptionRequestStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="requestId"> Request Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="requestId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/> is null. </exception>
        public virtual NullableResponse<GroupQuotaSubscriptionRequestStatusResource> GetIfExists(string requestId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(requestId, nameof(requestId));

            using var scope = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsClientDiagnostics.CreateScope("GroupQuotaSubscriptionRequestStatusCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _groupQuotaSubscriptionRequestStatusGroupQuotaSubscriptionRequestsRestClient.Get(Id.Parent.Name, Id.Name, requestId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaSubscriptionRequestStatusResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaSubscriptionRequestStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<GroupQuotaSubscriptionRequestStatusResource> IEnumerable<GroupQuotaSubscriptionRequestStatusResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<GroupQuotaSubscriptionRequestStatusResource> IAsyncEnumerable<GroupQuotaSubscriptionRequestStatusResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
