// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ManagementGroups;

namespace Azure.ResourceManager.Quota
{
    /// <summary>
    /// A class representing a collection of <see cref="GroupQuotaEntityResource"/> and their operations.
    /// Each <see cref="GroupQuotaEntityResource"/> in the collection will belong to the same instance of <see cref="ManagementGroupResource"/>.
    /// To get a <see cref="GroupQuotaEntityCollection"/> instance call the GetGroupQuotaEntities method from an instance of <see cref="ManagementGroupResource"/>.
    /// </summary>
    public partial class GroupQuotaEntityCollection : ArmCollection, IEnumerable<GroupQuotaEntityResource>, IAsyncEnumerable<GroupQuotaEntityResource>
    {
        private readonly ClientDiagnostics _groupQuotaEntityGroupQuotasClientDiagnostics;
        private readonly GroupQuotasRestOperations _groupQuotaEntityGroupQuotasRestClient;

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaEntityCollection"/> class for mocking. </summary>
        protected GroupQuotaEntityCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaEntityCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal GroupQuotaEntityCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _groupQuotaEntityGroupQuotasClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Quota", GroupQuotaEntityResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(GroupQuotaEntityResource.ResourceType, out string groupQuotaEntityGroupQuotasApiVersion);
            _groupQuotaEntityGroupQuotasRestClient = new GroupQuotasRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, groupQuotaEntityGroupQuotasApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ManagementGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ManagementGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The status can be polled periodically. The status Async polling is using standards defined at - https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations. Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be specified in retry-after header. Once the operation gets to terminal state - Succeeded | Failed, then the URI will change to Get URI and full details can be checked.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="data"> The GroupQuota body details for creation or update of a GroupQuota entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<GroupQuotaEntityResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string groupQuotaName, GroupQuotaEntityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _groupQuotaEntityGroupQuotasRestClient.CreateOrUpdateAsync(Id.Name, groupQuotaName, data, cancellationToken).ConfigureAwait(false);
                var operation = new QuotaArmOperation<GroupQuotaEntityResource>(new GroupQuotaEntityOperationSource(Client), _groupQuotaEntityGroupQuotasClientDiagnostics, Pipeline, _groupQuotaEntityGroupQuotasRestClient.CreateCreateOrUpdateRequest(Id.Name, groupQuotaName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The status can be polled periodically. The status Async polling is using standards defined at - https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations. Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be specified in retry-after header. Once the operation gets to terminal state - Succeeded | Failed, then the URI will change to Get URI and full details can be checked.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="data"> The GroupQuota body details for creation or update of a GroupQuota entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<GroupQuotaEntityResource> CreateOrUpdate(WaitUntil waitUntil, string groupQuotaName, GroupQuotaEntityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _groupQuotaEntityGroupQuotasRestClient.CreateOrUpdate(Id.Name, groupQuotaName, data, cancellationToken);
                var operation = new QuotaArmOperation<GroupQuotaEntityResource>(new GroupQuotaEntityOperationSource(Client), _groupQuotaEntityGroupQuotasClientDiagnostics, Pipeline, _groupQuotaEntityGroupQuotasRestClient.CreateCreateOrUpdateRequest(Id.Name, groupQuotaName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the GroupQuotas for the name passed. It will return the GroupQuotas properties only. The details on group quota can be access from the group quota APIs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual async Task<Response<GroupQuotaEntityResource>> GetAsync(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.Get");
            scope.Start();
            try
            {
                var response = await _groupQuotaEntityGroupQuotasRestClient.GetAsync(Id.Name, groupQuotaName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the GroupQuotas for the name passed. It will return the GroupQuotas properties only. The details on group quota can be access from the group quota APIs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual Response<GroupQuotaEntityResource> Get(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.Get");
            scope.Start();
            try
            {
                var response = _groupQuotaEntityGroupQuotasRestClient.Get(Id.Name, groupQuotaName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists GroupQuotas for the scope passed. It will return the GroupQuotas QuotaEntity properties only.The details on group quota can be access from the group quota APIs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="GroupQuotaEntityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<GroupQuotaEntityResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaEntityGroupQuotasRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaEntityGroupQuotasRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaEntityResource(Client, GroupQuotaEntityData.DeserializeGroupQuotaEntityData(e)), _groupQuotaEntityGroupQuotasClientDiagnostics, Pipeline, "GroupQuotaEntityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists GroupQuotas for the scope passed. It will return the GroupQuotas QuotaEntity properties only.The details on group quota can be access from the group quota APIs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="GroupQuotaEntityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<GroupQuotaEntityResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaEntityGroupQuotasRestClient.CreateListRequest(Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaEntityGroupQuotasRestClient.CreateListNextPageRequest(nextLink, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaEntityResource(Client, GroupQuotaEntityData.DeserializeGroupQuotaEntityData(e)), _groupQuotaEntityGroupQuotasClientDiagnostics, Pipeline, "GroupQuotaEntityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.Exists");
            scope.Start();
            try
            {
                var response = await _groupQuotaEntityGroupQuotasRestClient.GetAsync(Id.Name, groupQuotaName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual Response<bool> Exists(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.Exists");
            scope.Start();
            try
            {
                var response = _groupQuotaEntityGroupQuotasRestClient.Get(Id.Name, groupQuotaName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual async Task<NullableResponse<GroupQuotaEntityResource>> GetIfExistsAsync(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _groupQuotaEntityGroupQuotasRestClient.GetAsync(Id.Name, groupQuotaName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaEntityResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotas_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="groupQuotaName"> The GroupQuota name. The name should be unique for the provided context tenantId/MgId. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="groupQuotaName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="groupQuotaName"/> is null. </exception>
        public virtual NullableResponse<GroupQuotaEntityResource> GetIfExists(string groupQuotaName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(groupQuotaName, nameof(groupQuotaName));

            using var scope = _groupQuotaEntityGroupQuotasClientDiagnostics.CreateScope("GroupQuotaEntityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _groupQuotaEntityGroupQuotasRestClient.Get(Id.Name, groupQuotaName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaEntityResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<GroupQuotaEntityResource> IEnumerable<GroupQuotaEntityResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<GroupQuotaEntityResource> IAsyncEnumerable<GroupQuotaEntityResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
