// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Quota
{
    /// <summary>
    /// A class representing a collection of <see cref="GroupQuotaEnforcementResource"/> and their operations.
    /// Each <see cref="GroupQuotaEnforcementResource"/> in the collection will belong to the same instance of <see cref="GroupQuotaEntityResource"/>.
    /// To get a <see cref="GroupQuotaEnforcementCollection"/> instance call the GetGroupQuotaEnforcements method from an instance of <see cref="GroupQuotaEntityResource"/>.
    /// </summary>
    public partial class GroupQuotaEnforcementCollection : ArmCollection, IEnumerable<GroupQuotaEnforcementResource>, IAsyncEnumerable<GroupQuotaEnforcementResource>
    {
        private readonly ClientDiagnostics _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics;
        private readonly GroupQuotaLocationSettingsRestOperations _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient;
        private readonly string _resourceProviderName;

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaEnforcementCollection"/> class for mocking. </summary>
        protected GroupQuotaEnforcementCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="GroupQuotaEnforcementCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="resourceProviderName"> The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource provider supports this API. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceProviderName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="resourceProviderName"/> is an empty string, and was expected to be non-empty. </exception>
        internal GroupQuotaEnforcementCollection(ArmClient client, ResourceIdentifier id, string resourceProviderName) : base(client, id)
        {
            _resourceProviderName = resourceProviderName;
            _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Quota", GroupQuotaEnforcementResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(GroupQuotaEnforcementResource.ResourceType, out string groupQuotaEnforcementGroupQuotaLocationSettingsApiVersion);
            _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient = new GroupQuotaLocationSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, groupQuotaEnforcementGroupQuotaLocationSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != GroupQuotaEntityResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, GroupQuotaEntityResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource provider will start using the group quotas as the overall quota for the subscriptions included in the GroupQuota. The subscriptions cannot request quota at subscription level.
        /// The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource - provider/location/resource.
        /// Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To disable GroupQuota Enforcement -
        ///  1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
        ///  2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="data"> The GroupQuota body details for creation or update of a GroupQuota entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<GroupQuotaEnforcementResource>> CreateOrUpdateAsync(WaitUntil waitUntil, AzureLocation location, GroupQuotaEnforcementData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateOrUpdateAsync(Id.Parent.Name, Id.Name, _resourceProviderName, location, data, cancellationToken).ConfigureAwait(false);
                var operation = new QuotaArmOperation<GroupQuotaEnforcementResource>(new GroupQuotaEnforcementOperationSource(Client), _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics, Pipeline, _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateCreateOrUpdateRequest(Id.Parent.Name, Id.Name, _resourceProviderName, location, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource provider will start using the group quotas as the overall quota for the subscriptions included in the GroupQuota. The subscriptions cannot request quota at subscription level.
        /// The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource - provider/location/resource.
        /// Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To disable GroupQuota Enforcement -
        ///  1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
        ///  2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="data"> The GroupQuota body details for creation or update of a GroupQuota entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<GroupQuotaEnforcementResource> CreateOrUpdate(WaitUntil waitUntil, AzureLocation location, GroupQuotaEnforcementData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateOrUpdate(Id.Parent.Name, Id.Name, _resourceProviderName, location, data, cancellationToken);
                var operation = new QuotaArmOperation<GroupQuotaEnforcementResource>(new GroupQuotaEnforcementOperationSource(Client), _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics, Pipeline, _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateCreateOrUpdateRequest(Id.Parent.Name, Id.Name, _resourceProviderName, location, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the GroupQuotas enforcement settings for the ResourceProvider/location. The locations, where GroupQuota enforcement is not enabled will return Not Found.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<GroupQuotaEnforcementResource>> GetAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.Get");
            scope.Start();
            try
            {
                var response = await _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.GetAsync(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEnforcementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the GroupQuotas enforcement settings for the ResourceProvider/location. The locations, where GroupQuota enforcement is not enabled will return Not Found.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<GroupQuotaEnforcementResource> Get(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.Get");
            scope.Start();
            try
            {
                var response = _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.Get(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEnforcementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns only the list of the Azure regions settings, where the GroupQuotas enforcement is enabled. The locations not included in GroupQuota Enforcement will not be listed, the regions in failed status with listed as status Failed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="GroupQuotaEnforcementResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<GroupQuotaEnforcementResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateListRequest(Id.Parent.Name, Id.Name, _resourceProviderName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Name, Id.Name, _resourceProviderName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaEnforcementResource(Client, GroupQuotaEnforcementData.DeserializeGroupQuotaEnforcementData(e)), _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics, Pipeline, "GroupQuotaEnforcementCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns only the list of the Azure regions settings, where the GroupQuotas enforcement is enabled. The locations not included in GroupQuota Enforcement will not be listed, the regions in failed status with listed as status Failed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="GroupQuotaEnforcementResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<GroupQuotaEnforcementResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateListRequest(Id.Parent.Name, Id.Name, _resourceProviderName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.CreateListNextPageRequest(nextLink, Id.Parent.Name, Id.Name, _resourceProviderName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new GroupQuotaEnforcementResource(Client, GroupQuotaEnforcementData.DeserializeGroupQuotaEnforcementData(e)), _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics, Pipeline, "GroupQuotaEnforcementCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.Exists");
            scope.Start();
            try
            {
                var response = await _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.GetAsync(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.Exists");
            scope.Start();
            try
            {
                var response = _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.Get(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<GroupQuotaEnforcementResource>> GetIfExistsAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.GetAsync(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaEnforcementResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEnforcementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GroupQuotaLocationSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GroupQuotaEnforcementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<GroupQuotaEnforcementResource> GetIfExists(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = _groupQuotaEnforcementGroupQuotaLocationSettingsClientDiagnostics.CreateScope("GroupQuotaEnforcementCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _groupQuotaEnforcementGroupQuotaLocationSettingsRestClient.Get(Id.Parent.Name, Id.Name, _resourceProviderName, location, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<GroupQuotaEnforcementResource>(response.GetRawResponse());
                return Response.FromValue(new GroupQuotaEnforcementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<GroupQuotaEnforcementResource> IEnumerable<GroupQuotaEnforcementResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<GroupQuotaEnforcementResource> IAsyncEnumerable<GroupQuotaEnforcementResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
