// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Quota.Models;

namespace Azure.ResourceManager.Quota.Samples
{
    public partial class Sample_GroupQuotaEnforcementResource
    {
        // GroupQuotaLocationSettings_Patch
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_GroupQuotaLocationSettingsPatch()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotasEnforcement/PatchGroupQuotaEnforcement.json
            // this example is just showing the usage of "GroupQuotaLocationSettings_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GroupQuotaEnforcementResource created on azure
            // for more information of creating GroupQuotaEnforcementResource, please refer to the document of GroupQuotaEnforcementResource
            string managementGroupId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09";
            string groupQuotaName = "groupquota1";
            string resourceProviderName = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            ResourceIdentifier groupQuotaEnforcementResourceId = GroupQuotaEnforcementResource.CreateResourceIdentifier(managementGroupId, groupQuotaName, resourceProviderName, location);
            GroupQuotaEnforcementResource groupQuotaEnforcement = client.GetGroupQuotaEnforcementResource(groupQuotaEnforcementResourceId);

            // invoke the operation
            GroupQuotaEnforcementData data = new GroupQuotaEnforcementData()
            {
                Properties = new GroupQuotaEnforcementProperties()
                {
                    EnforcementEnabled = GroupQuotaEnforcementState.Enabled,
                },
            };
            ArmOperation<GroupQuotaEnforcementResource> lro = await groupQuotaEnforcement.UpdateAsync(WaitUntil.Completed, data);
            GroupQuotaEnforcementResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GroupQuotaEnforcementData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GroupQuotasEnforcement_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GroupQuotasEnforcementGet()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotasEnforcement/GetGroupQuotaEnforcement.json
            // this example is just showing the usage of "GroupQuotaLocationSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GroupQuotaEnforcementResource created on azure
            // for more information of creating GroupQuotaEnforcementResource, please refer to the document of GroupQuotaEnforcementResource
            string managementGroupId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09";
            string groupQuotaName = "groupquota1";
            string resourceProviderName = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            ResourceIdentifier groupQuotaEnforcementResourceId = GroupQuotaEnforcementResource.CreateResourceIdentifier(managementGroupId, groupQuotaName, resourceProviderName, location);
            GroupQuotaEnforcementResource groupQuotaEnforcement = client.GetGroupQuotaEnforcementResource(groupQuotaEnforcementResourceId);

            // invoke the operation
            GroupQuotaEnforcementResource result = await groupQuotaEnforcement.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GroupQuotaEnforcementData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
