// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Quota.Models;

namespace Azure.ResourceManager.Quota.Samples
{
    public partial class Sample_CurrentQuotaLimitBaseCollection
    {
        // Quotas_Get_Request_ForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotasGetRequestForCompute()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "standardNDSFamily";
            CurrentQuotaLimitBaseResource result = await collection.GetAsync(resourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_Get_Request_ForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_QuotasGetRequestForCompute()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "standardNDSFamily";
            bool result = await collection.ExistsAsync(resourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Quotas_Get_Request_ForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_QuotasGetRequestForCompute()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "standardNDSFamily";
            NullableResponse<CurrentQuotaLimitBaseResource> response = await collection.GetIfExistsAsync(resourceName);
            CurrentQuotaLimitBaseResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CurrentQuotaLimitBaseData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Quotas_UsagesRequest_ForNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotasUsagesRequestForNetwork()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "MinPublicIpInterNetworkPrefixLength";
            CurrentQuotaLimitBaseResource result = await collection.GetAsync(resourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_UsagesRequest_ForNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_QuotasUsagesRequestForNetwork()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "MinPublicIpInterNetworkPrefixLength";
            bool result = await collection.ExistsAsync(resourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Quotas_UsagesRequest_ForNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_QuotasUsagesRequestForNetwork()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkOneSkuQuotaLimit.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "MinPublicIpInterNetworkPrefixLength";
            NullableResponse<CurrentQuotaLimitBaseResource> response = await collection.GetIfExistsAsync(resourceName);
            CurrentQuotaLimitBaseResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CurrentQuotaLimitBaseData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Quotas_PutRequest_ForNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_QuotasPutRequestForNetwork()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putNetworkOneSkuQuotaRequest.json
            // this example is just showing the usage of "Quota_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "MinPublicIpInterNetworkPrefixLength";
            CurrentQuotaLimitBaseData data = new CurrentQuotaLimitBaseData()
            {
                Properties = new QuotaProperties()
                {
                    Limit = new QuotaLimitObject(10),
                    Name = new QuotaRequestResourceName()
                    {
                        Value = "MinPublicIpInterNetworkPrefixLength",
                    },
                    ResourceTypeName = "MinPublicIpInterNetworkPrefixLength",
                },
            };
            ArmOperation<CurrentQuotaLimitBaseResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            CurrentQuotaLimitBaseResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_PutRequest_ForNetwork_StandardSkuPublicIpAddressesResource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_QuotasPutRequestForNetworkStandardSkuPublicIpAddressesResource()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putNetworkOneSkuQuotaRequestStandardSkuPublicIpAddresses.json
            // this example is just showing the usage of "Quota_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "StandardSkuPublicIpAddresses";
            CurrentQuotaLimitBaseData data = new CurrentQuotaLimitBaseData()
            {
                Properties = new QuotaProperties()
                {
                    Limit = new QuotaLimitObject(10),
                    Name = new QuotaRequestResourceName()
                    {
                        Value = "StandardSkuPublicIpAddresses",
                    },
                    ResourceTypeName = "PublicIpAddresses",
                },
            };
            ArmOperation<CurrentQuotaLimitBaseResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            CurrentQuotaLimitBaseResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_Put_Request_ForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_QuotasPutRequestForCompute()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putComputeOneSkuQuotaRequest.json
            // this example is just showing the usage of "Quota_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Compute/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "standardFSv2Family";
            CurrentQuotaLimitBaseData data = new CurrentQuotaLimitBaseData()
            {
                Properties = new QuotaProperties()
                {
                    Limit = new QuotaLimitObject(10),
                    Name = new QuotaRequestResourceName()
                    {
                        Value = "standardFSv2Family",
                    },
                },
            };
            ArmOperation<CurrentQuotaLimitBaseResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            CurrentQuotaLimitBaseResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_Request_ForMachineLearningServices_LowPriorityResource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_QuotasRequestForMachineLearningServicesLowPriorityResource()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putMachineLearningServicesQuotaRequestLowPriority.json
            // this example is just showing the usage of "Quota_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.MachineLearningServices/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation
            string resourceName = "TotalLowPriorityCores";
            CurrentQuotaLimitBaseData data = new CurrentQuotaLimitBaseData()
            {
                Properties = new QuotaProperties()
                {
                    Limit = new QuotaLimitObject(10),
                    Name = new QuotaRequestResourceName()
                    {
                        Value = "TotalLowPriorityCores",
                    },
                    ResourceTypeName = "lowPriority",
                },
            };
            ArmOperation<CurrentQuotaLimitBaseResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            CurrentQuotaLimitBaseResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CurrentQuotaLimitBaseData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_listQuotaLimitsForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_QuotasListQuotaLimitsForCompute()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeQuotaLimits.json
            // this example is just showing the usage of "Quota_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation and iterate over the result
            await foreach (CurrentQuotaLimitBaseResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CurrentQuotaLimitBaseData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Quotas_listQuotaLimitsForNetwork
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_QuotasListQuotaLimitsForNetwork()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkQuotaLimits.json
            // this example is just showing the usage of "Quota_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation and iterate over the result
            await foreach (CurrentQuotaLimitBaseResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CurrentQuotaLimitBaseData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Quotas_listQuotaLimitsMachineLearningServices
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_QuotasListQuotaLimitsMachineLearningServices()
        {
            // Generated from example definition: specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getMachineLearningServicesQuotaLimits.json
            // this example is just showing the usage of "Quota_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this CurrentQuotaLimitBaseResource
            string scope = "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MachineLearningServices/locations/eastus";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            CurrentQuotaLimitBaseCollection collection = client.GetCurrentQuotaLimitBases(scopeId);

            // invoke the operation and iterate over the result
            await foreach (CurrentQuotaLimitBaseResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CurrentQuotaLimitBaseData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
