// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Qumulo.Models
{
    internal static partial class QumuloProvisioningStateExtensions
    {
        public static string ToSerialString(this QumuloProvisioningState value) => value switch
        {
            QumuloProvisioningState.NotSpecified => "NotSpecified",
            QumuloProvisioningState.Accepted => "Accepted",
            QumuloProvisioningState.Creating => "Creating",
            QumuloProvisioningState.Updating => "Updating",
            QumuloProvisioningState.Deleting => "Deleting",
            QumuloProvisioningState.Succeeded => "Succeeded",
            QumuloProvisioningState.Failed => "Failed",
            QumuloProvisioningState.Canceled => "Canceled",
            QumuloProvisioningState.Deleted => "Deleted",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QumuloProvisioningState value.")
        };

        public static QumuloProvisioningState ToQumuloProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return QumuloProvisioningState.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Accepted")) return QumuloProvisioningState.Accepted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return QumuloProvisioningState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Updating")) return QumuloProvisioningState.Updating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return QumuloProvisioningState.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return QumuloProvisioningState.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return QumuloProvisioningState.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return QumuloProvisioningState.Canceled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleted")) return QumuloProvisioningState.Deleted;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown QumuloProvisioningState value.");
        }
    }
}
