// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Qumulo.Models
{
    internal static partial class MarketplaceSubscriptionStatusExtensions
    {
        public static string ToSerialString(this MarketplaceSubscriptionStatus value) => value switch
        {
            MarketplaceSubscriptionStatus.PendingFulfillmentStart => "PendingFulfillmentStart",
            MarketplaceSubscriptionStatus.Subscribed => "Subscribed",
            MarketplaceSubscriptionStatus.Suspended => "Suspended",
            MarketplaceSubscriptionStatus.Unsubscribed => "Unsubscribed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MarketplaceSubscriptionStatus value.")
        };

        public static MarketplaceSubscriptionStatus ToMarketplaceSubscriptionStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "PendingFulfillmentStart")) return MarketplaceSubscriptionStatus.PendingFulfillmentStart;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Subscribed")) return MarketplaceSubscriptionStatus.Subscribed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Suspended")) return MarketplaceSubscriptionStatus.Suspended;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Unsubscribed")) return MarketplaceSubscriptionStatus.Unsubscribed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MarketplaceSubscriptionStatus value.");
        }
    }
}
