// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Quantum.Models
{
    /// <summary> Whether the current workspace is ready to accept Jobs. </summary>
    public readonly partial struct WorkspaceUsableStatus : IEquatable<WorkspaceUsableStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkspaceUsableStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkspaceUsableStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YesValue = "Yes";
        private const string NoValue = "No";
        private const string PartialValue = "Partial";

        /// <summary> Yes. </summary>
        public static WorkspaceUsableStatus Yes { get; } = new WorkspaceUsableStatus(YesValue);
        /// <summary> No. </summary>
        public static WorkspaceUsableStatus No { get; } = new WorkspaceUsableStatus(NoValue);
        /// <summary> Partial. </summary>
        public static WorkspaceUsableStatus Partial { get; } = new WorkspaceUsableStatus(PartialValue);
        /// <summary> Determines if two <see cref="WorkspaceUsableStatus"/> values are the same. </summary>
        public static bool operator ==(WorkspaceUsableStatus left, WorkspaceUsableStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkspaceUsableStatus"/> values are not the same. </summary>
        public static bool operator !=(WorkspaceUsableStatus left, WorkspaceUsableStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkspaceUsableStatus"/>. </summary>
        public static implicit operator WorkspaceUsableStatus(string value) => new WorkspaceUsableStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkspaceUsableStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkspaceUsableStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
