// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quantum.Models
{
    /// <summary> Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs. </summary>
    public partial class QuantumProvider
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QuantumProvider"/>. </summary>
        public QuantumProvider()
        {
        }

        /// <summary> Initializes a new instance of <see cref="QuantumProvider"/>. </summary>
        /// <param name="providerId"> Unique id of this provider. </param>
        /// <param name="providerSku"> The sku associated with pricing information for this provider. </param>
        /// <param name="instanceUri"> A Uri identifying the specific instance of this provider. </param>
        /// <param name="applicationName"> The provider's marketplace application display name. </param>
        /// <param name="provisioningState"> Provisioning status field. </param>
        /// <param name="resourceUsageId"> Id to track resource usage for the provider. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QuantumProvider(string providerId, string providerSku, Uri instanceUri, string applicationName, ProviderProvisioningStatus? provisioningState, string resourceUsageId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProviderId = providerId;
            ProviderSku = providerSku;
            InstanceUri = instanceUri;
            ApplicationName = applicationName;
            ProvisioningState = provisioningState;
            ResourceUsageId = resourceUsageId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique id of this provider. </summary>
        public string ProviderId { get; set; }
        /// <summary> The sku associated with pricing information for this provider. </summary>
        public string ProviderSku { get; set; }
        /// <summary> A Uri identifying the specific instance of this provider. </summary>
        public Uri InstanceUri { get; set; }
        /// <summary> The provider's marketplace application display name. </summary>
        public string ApplicationName { get; set; }
        /// <summary> Provisioning status field. </summary>
        public ProviderProvisioningStatus? ProvisioningState { get; set; }
        /// <summary> Id to track resource usage for the provider. </summary>
        public string ResourceUsageId { get; set; }
    }
}
