// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Quantum.Models
{
    public partial class QuantumProvider : IUtf8JsonSerializable, IJsonModel<QuantumProvider>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<QuantumProvider>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<QuantumProvider>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QuantumProvider>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(QuantumProvider)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ProviderId))
            {
                writer.WritePropertyName("providerId"u8);
                writer.WriteStringValue(ProviderId);
            }
            if (Optional.IsDefined(ProviderSku))
            {
                writer.WritePropertyName("providerSku"u8);
                writer.WriteStringValue(ProviderSku);
            }
            if (Optional.IsDefined(InstanceUri))
            {
                writer.WritePropertyName("instanceUri"u8);
                writer.WriteStringValue(InstanceUri.AbsoluteUri);
            }
            if (Optional.IsDefined(ApplicationName))
            {
                writer.WritePropertyName("applicationName"u8);
                writer.WriteStringValue(ApplicationName);
            }
            if (Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(ResourceUsageId))
            {
                writer.WritePropertyName("resourceUsageId"u8);
                writer.WriteStringValue(ResourceUsageId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        QuantumProvider IJsonModel<QuantumProvider>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QuantumProvider>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(QuantumProvider)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeQuantumProvider(document.RootElement, options);
        }

        internal static QuantumProvider DeserializeQuantumProvider(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string providerId = default;
            string providerSku = default;
            Uri instanceUri = default;
            string applicationName = default;
            ProviderProvisioningStatus? provisioningState = default;
            string resourceUsageId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("providerId"u8))
                {
                    providerId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("providerSku"u8))
                {
                    providerSku = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    instanceUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("applicationName"u8))
                {
                    applicationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new ProviderProvisioningStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resourceUsageId"u8))
                {
                    resourceUsageId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new QuantumProvider(
                providerId,
                providerSku,
                instanceUri,
                applicationName,
                provisioningState,
                resourceUsageId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<QuantumProvider>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QuantumProvider>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(QuantumProvider)} does not support writing '{options.Format}' format.");
            }
        }

        QuantumProvider IPersistableModel<QuantumProvider>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QuantumProvider>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeQuantumProvider(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(QuantumProvider)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<QuantumProvider>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
