// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Quantum.Models
{
    /// <summary> Information about a specific sku. </summary>
    public partial class ProviderSkuDescription
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProviderSkuDescription"/>. </summary>
        internal ProviderSkuDescription()
        {
            Targets = new ChangeTrackingList<string>();
            QuotaDimensions = new ChangeTrackingList<QuantumQuotaDimension>();
            PricingDetails = new ChangeTrackingList<QuantumPricingDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="ProviderSkuDescription"/>. </summary>
        /// <param name="id"> Unique sku id. </param>
        /// <param name="name"> Display name of this sku. </param>
        /// <param name="version"> Display name of this sku. </param>
        /// <param name="description"> Description about this sku. </param>
        /// <param name="restrictedAccessUri"> Uri to subscribe to the restricted access sku. </param>
        /// <param name="autoAdd"> Flag to indicate whether the sku should be automatically added during workspace creation. </param>
        /// <param name="targets"> The list of targets available for this sku. </param>
        /// <param name="quotaDimensions"> The list of quota dimensions for this sku. </param>
        /// <param name="pricingDetails"> The list of pricing details for the sku. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProviderSkuDescription(string id, string name, string version, string description, Uri restrictedAccessUri, bool? autoAdd, IReadOnlyList<string> targets, IReadOnlyList<QuantumQuotaDimension> quotaDimensions, IReadOnlyList<QuantumPricingDetail> pricingDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Version = version;
            Description = description;
            RestrictedAccessUri = restrictedAccessUri;
            AutoAdd = autoAdd;
            Targets = targets;
            QuotaDimensions = quotaDimensions;
            PricingDetails = pricingDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique sku id. </summary>
        public string Id { get; }
        /// <summary> Display name of this sku. </summary>
        public string Name { get; }
        /// <summary> Display name of this sku. </summary>
        public string Version { get; }
        /// <summary> Description about this sku. </summary>
        public string Description { get; }
        /// <summary> Uri to subscribe to the restricted access sku. </summary>
        public Uri RestrictedAccessUri { get; }
        /// <summary> Flag to indicate whether the sku should be automatically added during workspace creation. </summary>
        public bool? AutoAdd { get; }
        /// <summary> The list of targets available for this sku. </summary>
        public IReadOnlyList<string> Targets { get; }
        /// <summary> The list of quota dimensions for this sku. </summary>
        public IReadOnlyList<QuantumQuotaDimension> QuotaDimensions { get; }
        /// <summary> The list of pricing details for the sku. </summary>
        public IReadOnlyList<QuantumPricingDetail> PricingDetails { get; }
    }
}
