// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Quantum.Models
{
    public partial class ProviderSkuDescription : IUtf8JsonSerializable, IJsonModel<ProviderSkuDescription>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ProviderSkuDescription>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ProviderSkuDescription>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderSkuDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderSkuDescription)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(RestrictedAccessUri))
            {
                writer.WritePropertyName("restrictedAccessUri"u8);
                writer.WriteStringValue(RestrictedAccessUri.AbsoluteUri);
            }
            if (Optional.IsDefined(AutoAdd))
            {
                writer.WritePropertyName("autoAdd"u8);
                writer.WriteBooleanValue(AutoAdd.Value);
            }
            if (Optional.IsCollectionDefined(Targets))
            {
                writer.WritePropertyName("targets"u8);
                writer.WriteStartArray();
                foreach (var item in Targets)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(QuotaDimensions))
            {
                writer.WritePropertyName("quotaDimensions"u8);
                writer.WriteStartArray();
                foreach (var item in QuotaDimensions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PricingDetails))
            {
                writer.WritePropertyName("pricingDetails"u8);
                writer.WriteStartArray();
                foreach (var item in PricingDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ProviderSkuDescription IJsonModel<ProviderSkuDescription>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderSkuDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderSkuDescription)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeProviderSkuDescription(document.RootElement, options);
        }

        internal static ProviderSkuDescription DeserializeProviderSkuDescription(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string name = default;
            string version = default;
            string description = default;
            Uri restrictedAccessUri = default;
            bool? autoAdd = default;
            IReadOnlyList<string> targets = default;
            IReadOnlyList<QuantumQuotaDimension> quotaDimensions = default;
            IReadOnlyList<QuantumPricingDetail> pricingDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("restrictedAccessUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    restrictedAccessUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("autoAdd"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoAdd = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("targets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    targets = array;
                    continue;
                }
                if (property.NameEquals("quotaDimensions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<QuantumQuotaDimension> array = new List<QuantumQuotaDimension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(QuantumQuotaDimension.DeserializeQuantumQuotaDimension(item, options));
                    }
                    quotaDimensions = array;
                    continue;
                }
                if (property.NameEquals("pricingDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<QuantumPricingDetail> array = new List<QuantumPricingDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(QuantumPricingDetail.DeserializeQuantumPricingDetail(item, options));
                    }
                    pricingDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ProviderSkuDescription(
                id,
                name,
                version,
                description,
                restrictedAccessUri,
                autoAdd,
                targets ?? new ChangeTrackingList<string>(),
                quotaDimensions ?? new ChangeTrackingList<QuantumQuotaDimension>(),
                pricingDetails ?? new ChangeTrackingList<QuantumPricingDetail>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ProviderSkuDescription>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderSkuDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ProviderSkuDescription)} does not support writing '{options.Format}' format.");
            }
        }

        ProviderSkuDescription IPersistableModel<ProviderSkuDescription>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderSkuDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeProviderSkuDescription(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ProviderSkuDescription)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ProviderSkuDescription>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
