// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Quantum.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmQuantumModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Quantum.QuantumWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed Identity information. Current supported identity types: SystemAssigned, None. </param>
        /// <param name="providers"> List of Providers selected for this Workspace. </param>
        /// <param name="usable"> Whether the current workspace is ready to accept Jobs. </param>
        /// <param name="provisioningState"> Provisioning status field. </param>
        /// <param name="storageAccount"> ARM Resource Id of the storage account associated with this workspace. </param>
        /// <param name="endpointUri"> The URI of the workspace endpoint. </param>
        /// <param name="isApiKeyEnabled"> Indicator of enablement of the Quantum workspace Api keys. </param>
        /// <returns> A new <see cref="Quantum.QuantumWorkspaceData"/> instance for mocking. </returns>
        public static QuantumWorkspaceData QuantumWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, IEnumerable<QuantumProvider> providers = null, WorkspaceUsableStatus? usable = null, QuantumProvisioningStatus? provisioningState = null, string storageAccount = null, Uri endpointUri = null, bool? isApiKeyEnabled = null)
        {
            tags ??= new Dictionary<string, string>();
            providers ??= new List<QuantumProvider>();

            return new QuantumWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                providers?.ToList(),
                usable,
                provisioningState,
                storageAccount,
                endpointUri,
                isApiKeyEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuantumProviderDescription"/>. </summary>
        /// <param name="id"> Unique provider's id. </param>
        /// <param name="name"> Provider's display name. </param>
        /// <param name="properties"> Provider properties. </param>
        /// <returns> A new <see cref="Models.QuantumProviderDescription"/> instance for mocking. </returns>
        public static QuantumProviderDescription QuantumProviderDescription(string id = null, string name = null, QuantumProviderProperties properties = null)
        {
            return new QuantumProviderDescription(id, name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuantumProviderProperties"/>. </summary>
        /// <param name="description"> A description about this provider. </param>
        /// <param name="providerType"> Provider type. </param>
        /// <param name="company"> Company name. </param>
        /// <param name="defaultEndpoint"> Provider's default endpoint. </param>
        /// <param name="aad"> Azure Active Directory info. </param>
        /// <param name="managedApplication"> Provider's Managed-Application info. </param>
        /// <param name="targets"> The list of targets available from this provider. </param>
        /// <param name="skus"> The list of skus available from this provider. </param>
        /// <param name="quotaDimensions"> The list of quota dimensions from the provider. </param>
        /// <param name="pricingDimensions"> The list of pricing dimensions from the provider. </param>
        /// <returns> A new <see cref="Models.QuantumProviderProperties"/> instance for mocking. </returns>
        public static QuantumProviderProperties QuantumProviderProperties(string description = null, string providerType = null, string company = null, string defaultEndpoint = null, ProviderAadInfo aad = null, ProviderApplicationInfo managedApplication = null, IEnumerable<ProviderTargetDescription> targets = null, IEnumerable<ProviderSkuDescription> skus = null, IEnumerable<QuantumQuotaDimension> quotaDimensions = null, IEnumerable<ProviderPricingDimension> pricingDimensions = null)
        {
            targets ??= new List<ProviderTargetDescription>();
            skus ??= new List<ProviderSkuDescription>();
            quotaDimensions ??= new List<QuantumQuotaDimension>();
            pricingDimensions ??= new List<ProviderPricingDimension>();

            return new QuantumProviderProperties(
                description,
                providerType,
                company,
                defaultEndpoint,
                aad,
                managedApplication,
                targets?.ToList(),
                skus?.ToList(),
                quotaDimensions?.ToList(),
                pricingDimensions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderAadInfo"/>. </summary>
        /// <param name="applicationId"> Provider's application id. </param>
        /// <param name="tenantId"> Provider's tenant id. </param>
        /// <returns> A new <see cref="Models.ProviderAadInfo"/> instance for mocking. </returns>
        public static ProviderAadInfo ProviderAadInfo(string applicationId = null, Guid? tenantId = null)
        {
            return new ProviderAadInfo(applicationId, tenantId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderApplicationInfo"/>. </summary>
        /// <param name="publisherId"> Provider's publisher id. </param>
        /// <param name="offerId"> Provider's offer id. </param>
        /// <returns> A new <see cref="Models.ProviderApplicationInfo"/> instance for mocking. </returns>
        public static ProviderApplicationInfo ProviderApplicationInfo(string publisherId = null, string offerId = null)
        {
            return new ProviderApplicationInfo(publisherId, offerId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderTargetDescription"/>. </summary>
        /// <param name="id"> Unique target id. </param>
        /// <param name="name"> Display name of this target. </param>
        /// <param name="description"> A description about this target. </param>
        /// <param name="acceptedDataFormats"> List of data formats accepted by this target. </param>
        /// <param name="acceptedContentEncodings"> List of content encodings accepted by this target. </param>
        /// <returns> A new <see cref="Models.ProviderTargetDescription"/> instance for mocking. </returns>
        public static ProviderTargetDescription ProviderTargetDescription(string id = null, string name = null, string description = null, IEnumerable<string> acceptedDataFormats = null, IEnumerable<string> acceptedContentEncodings = null)
        {
            acceptedDataFormats ??= new List<string>();
            acceptedContentEncodings ??= new List<string>();

            return new ProviderTargetDescription(
                id,
                name,
                description,
                acceptedDataFormats?.ToList(),
                acceptedContentEncodings?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderSkuDescription"/>. </summary>
        /// <param name="id"> Unique sku id. </param>
        /// <param name="name"> Display name of this sku. </param>
        /// <param name="version"> Display name of this sku. </param>
        /// <param name="description"> Description about this sku. </param>
        /// <param name="restrictedAccessUri"> Uri to subscribe to the restricted access sku. </param>
        /// <param name="autoAdd"> Flag to indicate whether the sku should be automatically added during workspace creation. </param>
        /// <param name="targets"> The list of targets available for this sku. </param>
        /// <param name="quotaDimensions"> The list of quota dimensions for this sku. </param>
        /// <param name="pricingDetails"> The list of pricing details for the sku. </param>
        /// <returns> A new <see cref="Models.ProviderSkuDescription"/> instance for mocking. </returns>
        public static ProviderSkuDescription ProviderSkuDescription(string id = null, string name = null, string version = null, string description = null, Uri restrictedAccessUri = null, bool? autoAdd = null, IEnumerable<string> targets = null, IEnumerable<QuantumQuotaDimension> quotaDimensions = null, IEnumerable<QuantumPricingDetail> pricingDetails = null)
        {
            targets ??= new List<string>();
            quotaDimensions ??= new List<QuantumQuotaDimension>();
            pricingDetails ??= new List<QuantumPricingDetail>();

            return new ProviderSkuDescription(
                id,
                name,
                version,
                description,
                restrictedAccessUri,
                autoAdd,
                targets?.ToList(),
                quotaDimensions?.ToList(),
                pricingDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuantumQuotaDimension"/>. </summary>
        /// <param name="id"> Unique id of this dimension. </param>
        /// <param name="scope"> The scope of this quota dimension. </param>
        /// <param name="period"> The reset period of this quota dimension. </param>
        /// <param name="quota"> The max limit of this dimension. </param>
        /// <param name="name"> The display name of this quota dimension. </param>
        /// <param name="description"> A description about this quota dimension. </param>
        /// <param name="unit"> The standard unit of measurement used for this quota dimension. </param>
        /// <param name="unitPlural"> The standard unit of measurement used for this quota dimension in plural form. </param>
        /// <returns> A new <see cref="Models.QuantumQuotaDimension"/> instance for mocking. </returns>
        public static QuantumQuotaDimension QuantumQuotaDimension(string id = null, string scope = null, string period = null, float? quota = null, string name = null, string description = null, string unit = null, string unitPlural = null)
        {
            return new QuantumQuotaDimension(
                id,
                scope,
                period,
                quota,
                name,
                description,
                unit,
                unitPlural,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuantumPricingDetail"/>. </summary>
        /// <param name="id"> Unique id for this pricing information. </param>
        /// <param name="value"> The unit cost of this sku. </param>
        /// <returns> A new <see cref="Models.QuantumPricingDetail"/> instance for mocking. </returns>
        public static QuantumPricingDetail QuantumPricingDetail(string id = null, string value = null)
        {
            return new QuantumPricingDetail(id, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderPricingDimension"/>. </summary>
        /// <param name="id"> Unique id of this pricing dimension. </param>
        /// <param name="name"> The display name of this pricing dimension. </param>
        /// <returns> A new <see cref="Models.ProviderPricingDimension"/> instance for mocking. </returns>
        public static ProviderPricingDimension ProviderPricingDimension(string id = null, string name = null)
        {
            return new ProviderPricingDimension(id, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkspaceNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicator of availability of the Quantum Workspace resource name. </param>
        /// <param name="reason"> The reason of unavailability. </param>
        /// <param name="message"> The detailed info regarding the reason associated with the Namespace. </param>
        /// <returns> A new <see cref="Models.WorkspaceNameAvailabilityResult"/> instance for mocking. </returns>
        public static WorkspaceNameAvailabilityResult WorkspaceNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new WorkspaceNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkspaceKeyListResult"/>. </summary>
        /// <param name="isApiKeyEnabled"> Indicator of enablement of the Quantum workspace Api keys. </param>
        /// <param name="primaryKey"> The quantum workspace primary api key. </param>
        /// <param name="secondaryKey"> The quantum workspace secondary api key. </param>
        /// <param name="primaryConnectionString"> The connection string of the primary api key. </param>
        /// <param name="secondaryConnectionString"> The connection string of the secondary api key. </param>
        /// <returns> A new <see cref="Models.WorkspaceKeyListResult"/> instance for mocking. </returns>
        public static WorkspaceKeyListResult WorkspaceKeyListResult(bool? isApiKeyEnabled = null, WorkspaceApiKey primaryKey = null, WorkspaceApiKey secondaryKey = null, string primaryConnectionString = null, string secondaryConnectionString = null)
        {
            return new WorkspaceKeyListResult(
                isApiKeyEnabled,
                primaryKey,
                secondaryKey,
                primaryConnectionString,
                secondaryConnectionString,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkspaceApiKey"/>. </summary>
        /// <param name="createdOn"> The creation time of the api key. </param>
        /// <param name="key"> The Api key. </param>
        /// <returns> A new <see cref="Models.WorkspaceApiKey"/> instance for mocking. </returns>
        public static WorkspaceApiKey WorkspaceApiKey(DateTimeOffset? createdOn = null, string key = null)
        {
            return new WorkspaceApiKey(createdOn, key, serializedAdditionalRawData: null);
        }
    }
}
