// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Quantum.Jobs.Models
{
    /// <summary> Target status. </summary>
    public partial class TargetStatus
    {
        /// <summary> Initializes a new instance of <see cref="TargetStatus"/>. </summary>
        internal TargetStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TargetStatus"/>. </summary>
        /// <param name="id"> Target id. </param>
        /// <param name="currentAvailability"> Target availability. </param>
        /// <param name="averageQueueTime"> Average queue time in seconds. </param>
        /// <param name="statusPage"> A page with detailed status of the provider. </param>
        internal TargetStatus(string id, TargetAvailability? currentAvailability, long? averageQueueTime, string statusPage)
        {
            Id = id;
            CurrentAvailability = currentAvailability;
            AverageQueueTime = averageQueueTime;
            StatusPage = statusPage;
        }

        /// <summary> Target id. </summary>
        public string Id { get; }
        /// <summary> Target availability. </summary>
        public TargetAvailability? CurrentAvailability { get; }
        /// <summary> Average queue time in seconds. </summary>
        public long? AverageQueueTime { get; }
        /// <summary> A page with detailed status of the provider. </summary>
        public string StatusPage { get; }
    }
}
