// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Quantum.Jobs.Models
{
    public partial class TargetStatus
    {
        internal static TargetStatus DeserializeTargetStatus(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            TargetAvailability? currentAvailability = default;
            long? averageQueueTime = default;
            string statusPage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("currentAvailability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentAvailability = new TargetAvailability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("averageQueueTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    averageQueueTime = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("statusPage"u8))
                {
                    statusPage = property.Value.GetString();
                    continue;
                }
            }
            return new TargetStatus(id, currentAvailability, averageQueueTime, statusPage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TargetStatus FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTargetStatus(document.RootElement);
        }
    }
}
