// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Quantum.Jobs.Models
{
    internal partial class RestError
    {
        internal static RestError DeserializeRestError(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ErrorData error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = ErrorData.DeserializeErrorData(property.Value);
                    continue;
                }
            }
            return new RestError(error);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RestError FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRestError(document.RootElement);
        }
    }
}
