// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Quantum.Jobs.Models
{
    internal partial class ProviderStatusList
    {
        internal static ProviderStatusList DeserializeProviderStatusList(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ProviderStatus> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ProviderStatus> array = new List<ProviderStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ProviderStatus.DeserializeProviderStatus(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new ProviderStatusList(value ?? new ChangeTrackingList<ProviderStatus>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ProviderStatusList FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeProviderStatusList(document.RootElement);
        }
    }
}
