// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Quantum.Jobs.Models
{
    public partial class ProviderStatus
    {
        internal static ProviderStatus DeserializeProviderStatus(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            ProviderAvailability? currentAvailability = default;
            IReadOnlyList<TargetStatus> targets = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("currentAvailability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentAvailability = new ProviderAvailability(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TargetStatus> array = new List<TargetStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TargetStatus.DeserializeTargetStatus(item));
                    }
                    targets = array;
                    continue;
                }
            }
            return new ProviderStatus(id, currentAvailability, targets ?? new ChangeTrackingList<TargetStatus>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ProviderStatus FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeProviderStatus(document.RootElement);
        }
    }
}
