// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Quantum.Jobs.Models
{
    /// <summary> The operation to be performed. </summary>
    public readonly partial struct JsonPatchOperation : IEquatable<JsonPatchOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JsonPatchOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JsonPatchOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddValue = "add";
        private const string RemoveValue = "remove";
        private const string ReplaceValue = "replace";
        private const string MoveValue = "move";
        private const string CopyValue = "copy";
        private const string TestValue = "test";

        /// <summary> add. </summary>
        public static JsonPatchOperation Add { get; } = new JsonPatchOperation(AddValue);
        /// <summary> remove. </summary>
        public static JsonPatchOperation Remove { get; } = new JsonPatchOperation(RemoveValue);
        /// <summary> replace. </summary>
        public static JsonPatchOperation Replace { get; } = new JsonPatchOperation(ReplaceValue);
        /// <summary> move. </summary>
        public static JsonPatchOperation Move { get; } = new JsonPatchOperation(MoveValue);
        /// <summary> copy. </summary>
        public static JsonPatchOperation Copy { get; } = new JsonPatchOperation(CopyValue);
        /// <summary> test. </summary>
        public static JsonPatchOperation Test { get; } = new JsonPatchOperation(TestValue);
        /// <summary> Determines if two <see cref="JsonPatchOperation"/> values are the same. </summary>
        public static bool operator ==(JsonPatchOperation left, JsonPatchOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JsonPatchOperation"/> values are not the same. </summary>
        public static bool operator !=(JsonPatchOperation left, JsonPatchOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JsonPatchOperation"/>. </summary>
        public static implicit operator JsonPatchOperation(string value) => new JsonPatchOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JsonPatchOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JsonPatchOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
