// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Quantum.Jobs.Models
{
    /// <summary> The scope at which the quota is applied. </summary>
    public readonly partial struct DimensionScope : IEquatable<DimensionScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DimensionScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DimensionScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WorkspaceValue = "Workspace";
        private const string SubscriptionValue = "Subscription";

        /// <summary> Workspace. </summary>
        public static DimensionScope Workspace { get; } = new DimensionScope(WorkspaceValue);
        /// <summary> Subscription. </summary>
        public static DimensionScope Subscription { get; } = new DimensionScope(SubscriptionValue);
        /// <summary> Determines if two <see cref="DimensionScope"/> values are the same. </summary>
        public static bool operator ==(DimensionScope left, DimensionScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DimensionScope"/> values are not the same. </summary>
        public static bool operator !=(DimensionScope left, DimensionScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DimensionScope"/>. </summary>
        public static implicit operator DimensionScope(string value) => new DimensionScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DimensionScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DimensionScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
