// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Quantum.Jobs.Models
{
    /// <summary> The job cost billed by the provider. The final cost on your bill might be slightly different due to added taxes and currency conversion rates. </summary>
    public partial class CostEstimate
    {
        /// <summary> Initializes a new instance of <see cref="CostEstimate"/>. </summary>
        internal CostEstimate()
        {
            Events = new ChangeTrackingList<UsageEvent>();
        }

        /// <summary> Initializes a new instance of <see cref="CostEstimate"/>. </summary>
        /// <param name="currencyCode"> The currency code. </param>
        /// <param name="events"> List of usage events. </param>
        /// <param name="estimatedTotal"> The estimated total. </param>
        internal CostEstimate(string currencyCode, IReadOnlyList<UsageEvent> events, float? estimatedTotal)
        {
            CurrencyCode = currencyCode;
            Events = events;
            EstimatedTotal = estimatedTotal;
        }

        /// <summary> The currency code. </summary>
        public string CurrencyCode { get; }
        /// <summary> List of usage events. </summary>
        public IReadOnlyList<UsageEvent> Events { get; }
        /// <summary> The estimated total. </summary>
        public float? EstimatedTotal { get; }
    }
}
