// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Quantum.Jobs.Models
{
    /// <summary> Blob details. </summary>
    public partial class BlobDetails
    {
        /// <summary> Initializes a new instance of <see cref="BlobDetails"/>. </summary>
        /// <param name="containerName"> The container name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="containerName"/> is null. </exception>
        public BlobDetails(string containerName)
        {
            Argument.AssertNotNull(containerName, nameof(containerName));

            ContainerName = containerName;
        }

        /// <summary> Initializes a new instance of <see cref="BlobDetails"/>. </summary>
        /// <param name="containerName"> The container name. </param>
        /// <param name="blobName"> The blob name. </param>
        internal BlobDetails(string containerName, string blobName)
        {
            ContainerName = containerName;
            BlobName = blobName;
        }

        /// <summary> The container name. </summary>
        public string ContainerName { get; }
        /// <summary> The blob name. </summary>
        public string BlobName { get; set; }
    }
}
