// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Purview.Models;

namespace Azure.ResourceManager.Purview
{
    /// <summary>
    /// A class representing the PurviewKafkaConfiguration data model.
    /// The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
    /// </summary>
    public partial class PurviewKafkaConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PurviewKafkaConfigurationData"/>. </summary>
        public PurviewKafkaConfigurationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PurviewKafkaConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="consumerGroup"> Consumer group for hook event hub. </param>
        /// <param name="credentials"> Credentials to access the event streaming service attached to the purview account. </param>
        /// <param name="eventHubPartitionId"> Optional partition Id for notification event hub. If not set, all partitions will be leveraged. </param>
        /// <param name="eventHubResourceId"></param>
        /// <param name="eventHubType"> The event hub type. </param>
        /// <param name="eventStreamingState"> The state of the event streaming service. </param>
        /// <param name="eventStreamingType"> The event streaming service type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PurviewKafkaConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string consumerGroup, PurviewCredentials credentials, string eventHubPartitionId, ResourceIdentifier eventHubResourceId, PurviewKafkaEventHubType? eventHubType, PurviewEventStreamingState? eventStreamingState, PurviewEventStreamingType? eventStreamingType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ConsumerGroup = consumerGroup;
            Credentials = credentials;
            EventHubPartitionId = eventHubPartitionId;
            EventHubResourceId = eventHubResourceId;
            EventHubType = eventHubType;
            EventStreamingState = eventStreamingState;
            EventStreamingType = eventStreamingType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Consumer group for hook event hub. </summary>
        public string ConsumerGroup { get; set; }
        /// <summary> Credentials to access the event streaming service attached to the purview account. </summary>
        public PurviewCredentials Credentials { get; set; }
        /// <summary> Optional partition Id for notification event hub. If not set, all partitions will be leveraged. </summary>
        public string EventHubPartitionId { get; set; }
        /// <summary> Gets or sets the event hub resource id. </summary>
        public ResourceIdentifier EventHubResourceId { get; set; }
        /// <summary> The event hub type. </summary>
        public PurviewKafkaEventHubType? EventHubType { get; set; }
        /// <summary> The state of the event streaming service. </summary>
        public PurviewEventStreamingState? EventStreamingState { get; set; }
        /// <summary> The event streaming service type. </summary>
        public PurviewEventStreamingType? EventStreamingType { get; set; }
    }
}
