// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Response for usage information. </summary>
    public partial class PurviewUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PurviewUsage"/>. </summary>
        internal PurviewUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PurviewUsage"/>. </summary>
        /// <param name="currentValue"> Current usage quota value. </param>
        /// <param name="id"> Fully qualified resource Id. </param>
        /// <param name="limit"> Usage quota limit. </param>
        /// <param name="name"> Quota name. </param>
        /// <param name="unit"> Quota usage unit. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PurviewUsage(int? currentValue, string id, int? limit, PurviewUsageName name, string unit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentValue = currentValue;
            Id = id;
            Limit = limit;
            Name = name;
            Unit = unit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current usage quota value. </summary>
        public int? CurrentValue { get; }
        /// <summary> Fully qualified resource Id. </summary>
        public string Id { get; }
        /// <summary> Usage quota limit. </summary>
        public int? Limit { get; }
        /// <summary> Quota name. </summary>
        public PurviewUsageName Name { get; }
        /// <summary> Quota usage unit. </summary>
        public string Unit { get; }
    }
}
